/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionStore;
import org.jboss.solder.logging.Logger;

@Named
public class PermissionManager
implements Serializable {
    private static final long serialVersionUID = -2694925751585231813L;
    public static final String PERMISSION_READ = "seam.read-permissions";
    public static final String PERMISSION_GRANT = "seam.grant-permission";
    public static final String PERMISSION_REVOKE = "seam.revoke-permission";
    private static final Logger log = Logger.getLogger(PermissionManager.class);
    @Inject
    PermissionStore permissionStore;
    @Inject
    Identity identity;

    public PermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    public void setPermissionStore(PermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    public List<Permission> listPermissions(Object target, String action) {
        if (target == null) {
            return null;
        }
        this.identity.checkPermission(target, PERMISSION_READ);
        return this.permissionStore.listPermissions(target, action);
    }

    public List<Permission> listPermissions(Object target) {
        if (target == null) {
            return null;
        }
        this.identity.checkPermission(target, PERMISSION_READ);
        return this.permissionStore.listPermissions(target);
    }

    public boolean grantPermission(Permission permission) {
        this.identity.checkPermission(permission.getResource(), PERMISSION_GRANT);
        return this.permissionStore.grantPermission(permission);
    }

    public boolean grantPermissions(List<Permission> permissions) {
        for (Permission permission : permissions) {
            this.identity.checkPermission(permission.getResource(), PERMISSION_GRANT);
        }
        return this.permissionStore.grantPermissions(permissions);
    }

    public boolean revokePermission(Permission permission) {
        this.identity.checkPermission(permission.getResource(), PERMISSION_REVOKE);
        return this.permissionStore.revokePermission(permission);
    }

    public boolean revokePermissions(List<Permission> permissions) {
        for (Permission permission : permissions) {
            this.identity.checkPermission(permission.getResource(), PERMISSION_REVOKE);
        }
        return this.permissionStore.revokePermissions(permissions);
    }

    public List<String> listAvailableActions(Object target) {
        return this.permissionStore.listAvailableActions(target);
    }

    public void clearPermissions(Object target) {
        if (this.permissionStore != null) {
            this.permissionStore.clearPermissions(target);
        }
    }
}

