/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.jboss.solder.logging.Logger;

@ApplicationScoped
public class SecurityRuleLoader {
    @Inject
    Logger log;
    @Inject
    @org.jboss.solder.resourceLoader.Resource(value="security.drl")
    InputStream securityRules;
    @Inject
    @org.jboss.solder.resourceLoader.Resource(value="WEB-INF/security.drl")
    InputStream webInfSecurityRules;
    private KnowledgeBase kbase;

    public KnowledgeBase getKnowledgeBase() {
        return this.kbase;
    }

    @Inject
    public void init() {
        InputStream rules;
        KnowledgeBuilderConfiguration config = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBaseConfiguration kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        InputStream inputStream = rules = this.securityRules != null ? this.securityRules : this.webInfSecurityRules;
        if (rules != null) {
            Resource resource = ResourceFactory.newInputStreamResource((InputStream)rules);
            kbuilder.add(resource, ResourceType.DRL);
            KnowledgeBuilderErrors kbuildererrors = kbuilder.getErrors();
            if (kbuildererrors.size() > 0) {
                for (KnowledgeBuilderError kbuildererror : kbuildererrors) {
                    this.log.error((Object)kbuildererror.getMessage());
                }
            }
            this.kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kBaseConfig);
            this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        } else {
            this.log.warn((Object)"No security rules configured - rule base permissions will be unavailable.");
        }
    }
}

