/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.NormalizedTerms;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.RuleIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindRulesQuery
implements NamedQuery {
    public static String FIND_RULES_QUERY = "FindRulesQuery";
    @Inject
    private DefaultResponseBuilder responseBuilder;

    @Override
    public String getName() {
        return FIND_RULES_QUERY;
    }

    @Override
    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new RuleIndexTerm());
            }
        };
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        NormalizedTerms normalizedTerms = new NormalizedTerms(terms, "ruleName");
        ValueIndexTerm ruleTerm = normalizedTerms.get("ruleName");
        BasicQueryBuilder builder = new BasicQueryBuilder(useWildcards);
        builder.addTerm(ruleTerm);
        return builder.build();
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

