/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.events.TemplateVariablesChangedEvent;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;

public class ActionInsertFactWidget
extends RuleModellerWidget {
    private final DirtyableFlexTable layout;
    private final ActionInsertFact model;
    private final String[] fieldCompletions;
    private final String factType;
    private boolean readOnly;
    private boolean isFactTypeKnown;

    public ActionInsertFactWidget(RuleModeller mod, EventBus eventBus, ActionInsertFact set, Boolean readOnly) {
        super(mod, eventBus);
        this.model = set;
        this.layout = new DirtyableFlexTable();
        this.factType = set.factType;
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        this.fieldCompletions = completions.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, set.factType);
        this.layout.setStyleName("model-builderInner-Background");
        this.isFactTypeKnown = completions.containsFactType(set.factType);
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getAssertLabel());
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        DirtyableFlexTable inner = new DirtyableFlexTable();
        int col = 0;
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldValue val = this.model.fieldValues[i];
            inner.setWidget(i, 0 + col, this.fieldSelector(val));
            inner.setWidget(i, 1 + col, this.valueEditor(val));
            final int idx = i;
            Image remove = DroolsGuvnorImages.INSTANCE.DeleteItemSmall();
            remove.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)Constants.INSTANCE.RemoveThisItem())) {
                        ActionInsertFactWidget.this.model.removeField(idx);
                        ActionInsertFactWidget.this.setModified(true);
                        ActionInsertFactWidget.this.getModeller().refreshWidget();
                        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(ActionInsertFactWidget.this.getModeller().getModel());
                        ActionInsertFactWidget.this.getEventBus().fireEventFromSource((GwtEvent)tvce, (Object)ActionInsertFactWidget.this.getModeller().getModel());
                    }
                }
            });
            if (this.readOnly) continue;
            inner.setWidget(i, 2 + col, (Widget)remove);
        }
        this.layout.setWidget(1, 1, (Widget)inner);
    }

    private Widget valueEditor(ActionFieldValue val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        DropDownData enums = completions.getEnums(this.factType, val.field, (FieldNature[])this.model.fieldValues);
        ActionValueEditor actionValueEditor = new ActionValueEditor(val, enums, this.getModeller(), this.getEventBus(), val.type, this.readOnly);
        actionValueEditor.setOnChangeCommand(new Command(){

            public void execute() {
                ActionInsertFactWidget.this.setModified(true);
            }
        });
        return actionValueEditor;
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.field);
    }

    private Widget getAssertLabel() {
        String lbl;
        ClickHandler cl = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget w = (Widget)event.getSource();
                ActionInsertFactWidget.this.showAddFieldPopup(w);
            }
        };
        String assertType = "assert";
        if (this.model instanceof ActionInsertLogicalFact) {
            assertType = "assertLogical";
        }
        String string = lbl = !this.model.isBound() ? HumanReadable.getActionDisplayName(assertType) + " <b>" + this.model.factType + "</b>" : HumanReadable.getActionDisplayName(assertType) + " <b>" + this.model.factType + "</b>" + " <b>[" + this.model.getBoundName() + "]</b>";
        if (this.model.fieldValues != null && this.model.fieldValues.length > 0) {
            lbl = lbl + ":";
        }
        return new ClickableLabel(lbl, cl, !this.readOnly);
    }

    protected void showAddFieldPopup(Widget w) {
        final SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        final FormStylePopup popup = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.AddAField());
        final ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(Constants.INSTANCE.AddField(), (Widget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fieldName = box.getItemText(box.getSelectedIndex());
                String fieldType = completions.getFieldType(((ActionInsertFactWidget)ActionInsertFactWidget.this).model.factType, fieldName);
                ActionInsertFactWidget.this.model.addFieldValue(new ActionFieldValue(fieldName, "", fieldType));
                ActionInsertFactWidget.this.setModified(true);
                ActionInsertFactWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        HorizontalPanel vn = new HorizontalPanel();
        final TextBox varName = new TextBox();
        if (this.model.getBoundName() != null) {
            varName.setText(this.model.getBoundName());
        }
        Button ok = new Button(Constants.INSTANCE.Set());
        vn.add((Widget)varName);
        vn.add((Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String var = varName.getText();
                if (ActionInsertFactWidget.this.getModeller().isVariableNameUsed(var) && (ActionInsertFactWidget.this.model.getBoundName() != null && !ActionInsertFactWidget.this.model.getBoundName().equals(var) || ActionInsertFactWidget.this.model.getBoundName() == null)) {
                    Window.alert((String)Constants.INSTANCE.TheVariableName0IsAlreadyTaken(var));
                    return;
                }
                ActionInsertFactWidget.this.model.setBoundName(var);
                ActionInsertFactWidget.this.setModified(true);
                ActionInsertFactWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.addAttribute(Constants.INSTANCE.BoundVariable(), (Widget)vn);
        popup.show();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }
}

