/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;

public class MethodParameterValueEditor
extends DirtyableComposite {
    private ActionFieldFunction methodParameter;
    private DropDownData enums;
    private SimplePanel root;
    private RuleModeller model = null;
    private String parameterType = null;
    private Command onValueChangeCommand = null;

    public MethodParameterValueEditor(ActionFieldFunction val, DropDownData enums, RuleModeller model, String parameterType, Command onValueChangeCommand) {
        this.enums = val.type.equals("Boolean") ? DropDownData.create((String[])new String[]{"true", "false"}) : enums;
        this.root = new SimplePanel();
        this.methodParameter = val;
        this.model = model;
        this.parameterType = parameterType;
        this.onValueChangeCommand = onValueChangeCommand;
        this.refresh();
        this.initWidget((Widget)this.root);
    }

    private void refresh() {
        this.root.clear();
        if (this.enums != null && (this.enums.fixedList != null || this.enums.queryExpression != null)) {
            this.root.add((Widget)new EnumDropDown(this.methodParameter.value, new DropDownValueChanged(){

                public void valueChanged(String newText, String newValue) {
                    ((MethodParameterValueEditor)MethodParameterValueEditor.this).methodParameter.value = newValue;
                    if (MethodParameterValueEditor.this.onValueChangeCommand != null) {
                        MethodParameterValueEditor.this.onValueChangeCommand.execute();
                    }
                    MethodParameterValueEditor.this.makeDirty();
                }
            }, this.enums));
        } else if (this.methodParameter.nature == 0L) {
            this.root.add(this.choice());
        } else if (this.methodParameter.nature == 2L) {
            ListBox list = this.boundVariable((FieldNature)this.methodParameter);
            this.root.add((Widget)list);
        } else {
            TextBox box = this.boundTextBox((ActionFieldValue)this.methodParameter);
            this.root.add((Widget)box);
        }
    }

    private ListBox boundVariable(FieldNature c) {
        ListBox listVariable = new ListBox();
        List vars = this.model.getModel().getLHSBoundFacts();
        for (String v : vars) {
            FactPattern factPattern = this.model.getModel().getLHSBoundFact(v);
            if (!factPattern.getFactType().equals(this.methodParameter.type)) continue;
            if (listVariable.getItemCount() == 0) {
                listVariable.addItem("...");
            }
            listVariable.addItem(v);
        }
        List vars2 = this.model.getModel().getRHSBoundFacts();
        for (String v : vars2) {
            ActionInsertFact factPattern = this.model.getModel().getRHSBoundFact(v);
            if (!factPattern.factType.equals(this.methodParameter.type)) continue;
            if (listVariable.getItemCount() == 0) {
                listVariable.addItem("...");
            }
            listVariable.addItem(v);
        }
        if (this.methodParameter.value.equals("=")) {
            listVariable.setSelectedIndex(0);
        } else {
            for (int i = 0; i < listVariable.getItemCount(); ++i) {
                if (!listVariable.getItemText(i).equals(this.methodParameter.value)) continue;
                listVariable.setSelectedIndex(i);
            }
        }
        if (listVariable.getItemCount() > 0) {
            listVariable.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ListBox w = (ListBox)event.getSource();
                    ((MethodParameterValueEditor)MethodParameterValueEditor.this).methodParameter.value = w.getValue(w.getSelectedIndex());
                    if (MethodParameterValueEditor.this.onValueChangeCommand != null) {
                        MethodParameterValueEditor.this.onValueChangeCommand.execute();
                    }
                    MethodParameterValueEditor.this.makeDirty();
                    MethodParameterValueEditor.this.refresh();
                }
            });
        }
        return listVariable;
    }

    private TextBox boundTextBox(final ActionFieldValue c) {
        final TextBox box = TextBoxFactory.getTextBox(this.methodParameter.type);
        box.setStyleName("constraint-value-Editor");
        if (c.value == null) {
            box.setText("");
        } else {
            if (c.value.trim().equals("")) {
                c.value = "";
            }
            box.setText(c.value);
        }
        if (c.value == null || c.value.length() < 5) {
            box.setVisibleLength(6);
        } else {
            box.setVisibleLength(c.value.length() - 1);
        }
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                c.value = box.getText();
                if (MethodParameterValueEditor.this.onValueChangeCommand != null) {
                    MethodParameterValueEditor.this.onValueChangeCommand.execute();
                }
                MethodParameterValueEditor.this.makeDirty();
            }
        });
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                box.setVisibleLength(box.getText().length());
            }
        });
        return box;
    }

    private Widget choice() {
        Image clickme = GuvnorImages.INSTANCE.Edit();
        clickme.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MethodParameterValueEditor.this.showTypeChoice((Widget)event.getSource());
            }
        });
        return clickme;
    }

    protected void showTypeChoice(Widget w) {
        final FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.FieldValue());
        Button lit = new Button(Constants.INSTANCE.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((MethodParameterValueEditor)MethodParameterValueEditor.this).methodParameter.nature = 1L;
                ((MethodParameterValueEditor)MethodParameterValueEditor.this).methodParameter.value = " ";
                MethodParameterValueEditor.this.makeDirty();
                MethodParameterValueEditor.this.refresh();
                form.hide();
            }
        });
        form.addAttribute(Constants.INSTANCE.LiteralValue() + ":", this.widgets(lit, new InfoPopup(Constants.INSTANCE.Literal(), Constants.INSTANCE.LiteralValTip())));
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(Constants.INSTANCE.AdvancedSection()));
        List vars = this.model.getModel().getLHSBoundFacts();
        List vars2 = this.model.getModel().getRHSBoundFacts();
        for (String i : vars2) {
            vars.add(i);
        }
        for (String v : vars) {
            FactPattern factPattern;
            boolean createButton = false;
            Button variable = new Button(Constants.INSTANCE.BoundVariable());
            if (!vars2.contains(v)) {
                factPattern = this.model.getModel().getLHSBoundFact(v);
                if (factPattern.getFactType().equals(this.parameterType)) {
                    createButton = true;
                }
            } else {
                factPattern = this.model.getModel().getRHSBoundFact(v);
                if (factPattern.factType.equals(this.parameterType)) {
                    createButton = true;
                }
            }
            if (!createButton) continue;
            form.addAttribute(Constants.INSTANCE.BoundVariable() + ":", (Widget)variable);
            variable.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ((MethodParameterValueEditor)MethodParameterValueEditor.this).methodParameter.nature = 2L;
                    ((MethodParameterValueEditor)MethodParameterValueEditor.this).methodParameter.value = "=";
                    MethodParameterValueEditor.this.makeDirty();
                    MethodParameterValueEditor.this.refresh();
                    form.hide();
                }
            });
            break;
        }
        form.show();
    }

    private Widget widgets(Button lit, InfoPopup popup) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)lit);
        h.add((Widget)popup);
        return h;
    }
}

