/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataColumn;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;

public class TemplateDataCellValueFactory
extends AbstractCellValueFactory<TemplateDataColumn, String> {
    private TemplateModel model;
    protected static DateConverter DATE_CONVERTOR = null;

    public static void injectDateConvertor(DateConverter dc) {
        DATE_CONVERTOR = dc;
    }

    public TemplateDataCellValueFactory(TemplateModel model, SuggestionCompletionEngine sce) {
        super(sce);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    @Override
    public List<String> makeRowData() {
        InterpolationVariable[] variables;
        ArrayList<String> data = new ArrayList<String>();
        for (InterpolationVariable var : variables = this.model.getInterpolationVariablesList()) {
            TemplateDataColumn column = this.makeModelColumn(var);
            String dcv = this.makeModelCellValue(column);
            data.add(dcv);
        }
        return data;
    }

    @Override
    public DynamicDataRow makeUIRowData() {
        InterpolationVariable[] variables;
        DynamicDataRow data = new DynamicDataRow();
        for (InterpolationVariable var : variables = this.model.getInterpolationVariablesList()) {
            TemplateDataColumn column = this.makeModelColumn(var);
            String dcv = this.makeModelCellValue(column);
            CellValue<? extends Comparable<?>> cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    @Override
    public List<String> makeColumnData(TemplateDataColumn column) {
        ArrayList<String> data = new ArrayList<String>();
        for (int iRow = 0; iRow < this.model.getRowsCount(); ++iRow) {
            String cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    @Override
    public List<CellValue<? extends Comparable<?>>> convertColumnData(TemplateDataColumn column, List<String> columnData) {
        ArrayList data = new ArrayList();
        for (int iRow = 0; iRow < this.model.getRowsCount(); ++iRow) {
            String dcv = columnData.get(iRow);
            CellValue<? extends Comparable<?>> cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    @Override
    public String makeModelCellValue(TemplateDataColumn column) {
        return new String();
    }

    @Override
    public CellValue<? extends Comparable<?>> convertModelCellValue(TemplateDataColumn column, String dcv) {
        DTDataTypes52 dataType = this.getDataType(column);
        CellValue<Object> cell = null;
        switch (dataType) {
            case BOOLEAN: {
                Boolean b = Boolean.FALSE;
                try {
                    b = Boolean.valueOf(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewBooleanCellValue(b);
                break;
            }
            case DATE: {
                Date d = null;
                try {
                    if (DATE_CONVERTOR == null) {
                        throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                    }
                    d = DATE_CONVERTOR.parse(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewDateCellValue(d);
                break;
            }
            case NUMERIC: {
                BigDecimal numericValue = null;
                try {
                    numericValue = new BigDecimal(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewNumericCellValue(numericValue);
                break;
            }
            case NUMERIC_BIGDECIMAL: {
                BigDecimal bigDecimalValue = null;
                try {
                    bigDecimalValue = new BigDecimal(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewBigDecimalCellValue(bigDecimalValue);
                break;
            }
            case NUMERIC_BIGINTEGER: {
                BigInteger bigIntegerValue = null;
                try {
                    bigIntegerValue = new BigInteger(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewBigIntegerCellValue(bigIntegerValue);
                break;
            }
            case NUMERIC_BYTE: {
                Byte byteValue = null;
                try {
                    byteValue = new Byte(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewByteCellValue(byteValue);
                break;
            }
            case NUMERIC_DOUBLE: {
                Double doubleValue = null;
                try {
                    doubleValue = new Double(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewDoubleCellValue(doubleValue);
                break;
            }
            case NUMERIC_FLOAT: {
                Float floatValue = null;
                try {
                    floatValue = new Float(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewFloatCellValue(floatValue);
                break;
            }
            case NUMERIC_INTEGER: {
                Integer integerValue = null;
                try {
                    integerValue = new Integer(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewIntegerCellValue(integerValue);
                break;
            }
            case NUMERIC_LONG: {
                Long longValue = null;
                try {
                    longValue = new Long(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewLongCellValue(longValue);
                break;
            }
            case NUMERIC_SHORT: {
                Short shortValue = null;
                try {
                    shortValue = new Short(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewShortCellValue(shortValue);
                break;
            }
            default: {
                cell = this.makeNewStringCellValue(dcv);
            }
        }
        return cell;
    }

    private DTDataTypes52 getDataType(TemplateDataColumn column) {
        String[] vals = null;
        String factType = column.getFactType();
        String factField = column.getFactField();
        if (factType != null && factField != null && (vals = this.sce.getEnumValues(factType, factField)) != null && vals.length > 0) {
            return DTDataTypes52.STRING;
        }
        String dataType = column.getDataType();
        if (dataType.equals("Boolean")) {
            return DTDataTypes52.BOOLEAN;
        }
        if (dataType.equals("Date")) {
            return DTDataTypes52.DATE;
        }
        if (dataType.equals("Numeric")) {
            return DTDataTypes52.NUMERIC;
        }
        if (dataType.equals("BigDecimal")) {
            return DTDataTypes52.NUMERIC_BIGDECIMAL;
        }
        if (dataType.equals("BigInteger")) {
            return DTDataTypes52.NUMERIC_BIGINTEGER;
        }
        if (dataType.equals("Byte")) {
            return DTDataTypes52.NUMERIC_BYTE;
        }
        if (dataType.equals("Double")) {
            return DTDataTypes52.NUMERIC_DOUBLE;
        }
        if (dataType.equals("Float")) {
            return DTDataTypes52.NUMERIC_FLOAT;
        }
        if (dataType.equals("Integer")) {
            return DTDataTypes52.NUMERIC_INTEGER;
        }
        if (dataType.equals("Long")) {
            return DTDataTypes52.NUMERIC_LONG;
        }
        if (dataType.equals("Short")) {
            return DTDataTypes52.NUMERIC_SHORT;
        }
        return DTDataTypes52.STRING;
    }

    public TemplateDataColumn makeModelColumn(InterpolationVariable var) {
        return new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField());
    }

    @Override
    public String convertToModelCell(TemplateDataColumn column, CellValue<?> cv) {
        DTDataTypes52 dataType = this.getDataType(column);
        switch (dataType) {
            case BOOLEAN: {
                return this.convertBooleanValueToString(cv);
            }
            case DATE: {
                return this.convertDateValueToString(cv);
            }
            case NUMERIC: {
                return this.convertNumericValueToString(cv);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.convertBigDecimalValueToString(cv);
            }
            case NUMERIC_BIGINTEGER: {
                return this.convertBigIntegerValueToString(cv);
            }
            case NUMERIC_BYTE: {
                return this.convertByteValueToString(cv);
            }
            case NUMERIC_DOUBLE: {
                return this.convertDoubleValueToString(cv);
            }
            case NUMERIC_FLOAT: {
                return this.convertFloatValueToString(cv);
            }
            case NUMERIC_INTEGER: {
                return this.convertIntegerValueToString(cv);
            }
            case NUMERIC_LONG: {
                return this.convertLongValueToString(cv);
            }
            case NUMERIC_SHORT: {
                return this.convertShortValueToString(cv);
            }
        }
        return this.convertStringValueToString(cv);
    }

    private String convertBooleanValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Boolean)value.getValue()).toString();
    }

    private String convertDateValueToString(CellValue<?> value) {
        String result = null;
        if (value.getValue() != null) {
            if (DATE_CONVERTOR == null) {
                throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
            }
            result = DATE_CONVERTOR.format((Date)value.getValue());
        }
        return result;
    }

    private String convertNumericValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((BigDecimal)value.getValue()).toPlainString();
    }

    private String convertBigDecimalValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((BigDecimal)value.getValue()).toPlainString();
    }

    private String convertBigIntegerValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((BigInteger)value.getValue()).toString();
    }

    private String convertByteValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Byte)value.getValue()).toString();
    }

    private String convertDoubleValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Double)value.getValue()).toString();
    }

    private String convertFloatValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Float)value.getValue()).toString();
    }

    private String convertIntegerValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Integer)value.getValue()).toString();
    }

    private String convertLongValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Long)value.getValue()).toString();
    }

    private String convertShortValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Short)value.getValue()).toString();
    }

    private String convertStringValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : (String)value.getValue();
    }
}

