/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;
import org.drools.guvnor.client.decisiontable.widget.BoundFactsChangedEvent;
import org.drools.guvnor.client.messages.Constants;

public class PopupBoundPatternDropDownEditCell
extends AbstractPopupEditCell<String, String>
implements BoundFactsChangedEvent.Handler {
    private final ListBox listBox = new ListBox();

    public PopupBoundPatternDropDownEditCell(EventBus eventBus, boolean isReadOnly) {
        super(isReadOnly);
        this.listBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupBoundPatternDropDownEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.listBox);
        eventBus.addHandler(BoundFactsChangedEvent.TYPE, (EventHandler)this);
    }

    public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value));
        }
    }

    @Override
    public void onBoundFactsChanged(BoundFactsChangedEvent event) {
        this.setFactBindings(event.getFactBindings());
    }

    public void setFactBindings(List<String> factBindings) {
        this.listBox.clear();
        for (String binding : factBindings) {
            this.listBox.addItem(binding);
        }
        this.listBox.setEnabled(this.listBox.getItemCount() > 0);
        if (this.listBox.getItemCount() == 0) {
            this.listBox.addItem(Constants.INSTANCE.NoPatternBindingsAvailable());
        }
    }

    @Override
    protected void commit() {
        if (!this.listBox.isEnabled()) {
            return;
        }
        String value = null;
        int selectedIndex = this.listBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            value = this.listBox.getValue(selectedIndex);
        }
        this.setValue(this.lastContext, this.lastParent, value);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)value);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, String value) {
        boolean emptyValue;
        boolean bl = emptyValue = value == null;
        if (emptyValue) {
            this.listBox.setSelectedIndex(0);
        } else {
            for (int i = 0; i < this.listBox.getItemCount(); ++i) {
                if (!this.listBox.getValue(i).equals(value)) continue;
                this.listBox.setSelectedIndex(i);
                break;
            }
        }
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupBoundPatternDropDownEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupBoundPatternDropDownEditCell.this.offsetX, parent.getAbsoluteTop() + PopupBoundPatternDropDownEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        PopupBoundPatternDropDownEditCell.this.listBox.setFocus(true);
                    }
                });
            }
        });
    }
}

