/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.NumericByteTextBox;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericByteEditCell
extends AbstractPopupEditCell<Byte, Byte> {
    private final TextBox textBox = new NumericByteTextBox();

    public PopupNumericByteEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupNumericByteEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, Byte value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toString()));
        }
    }

    @Override
    protected void commit() {
        String text = this.textBox.getValue();
        Byte number = null;
        if (text.length() > 0) {
            try {
                number = new Byte(text);
            }
            catch (NumberFormatException e) {
                number = new Byte("0");
            }
        }
        this.setValue(this.lastContext, this.lastParent, number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, Byte value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toString()));
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupNumericByteEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupNumericByteEditCell.this.offsetX, parent.getAbsoluteTop() + PopupNumericByteEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        String text = PopupNumericByteEditCell.this.textBox.getValue();
                        PopupNumericByteEditCell.this.textBox.setFocus(true);
                        PopupNumericByteEditCell.this.textBox.setCursorPos(text.length());
                        PopupNumericByteEditCell.this.textBox.setSelectionRange(0, text.length());
                    }
                });
            }
        });
    }
}

