/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.NumericIntegerTextBox;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericIntegerEditCell
extends AbstractPopupEditCell<Integer, Integer> {
    private final TextBox textBox = new NumericIntegerTextBox();

    public PopupNumericIntegerEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupNumericIntegerEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, Integer value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toString()));
        }
    }

    @Override
    protected void commit() {
        String text = this.textBox.getValue();
        Integer number = null;
        if (text.length() > 0) {
            try {
                number = new Integer(text);
            }
            catch (NumberFormatException e) {
                number = new Integer(0);
            }
        }
        this.setValue(this.lastContext, this.lastParent, number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, Integer value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toString()));
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupNumericIntegerEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupNumericIntegerEditCell.this.offsetX, parent.getAbsoluteTop() + PopupNumericIntegerEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        String text = PopupNumericIntegerEditCell.this.textBox.getValue();
                        PopupNumericIntegerEditCell.this.textBox.setFocus(true);
                        PopupNumericIntegerEditCell.this.textBox.setCursorPos(text.length());
                        PopupNumericIntegerEditCell.this.textBox.setSelectionRange(0, text.length());
                    }
                });
            }
        });
    }
}

