/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.rpc.AnalysisReportLine;
import org.drools.guvnor.client.rpc.Cause;

class VerifierMessageLinesItem
extends TreeItem {
    public VerifierMessageLinesItem(String topicHtml, AnalysisReportLine[] lines) {
        this.setStyleName("analysis-Report");
        this.setHTML(topicHtml);
        for (AnalysisReportLine line : lines) {
            TreeItem report = new TreeItem((Widget)new HTML(line.description));
            if (line.reason != null) {
                report.addItem(new TreeItem((Widget)new HTML("<b>" + Constants.INSTANCE.Reason() + ":</b>&nbsp;" + line.reason)));
            }
            TreeItem impactedRules = this.doImpactedRules(line);
            report.addItem(impactedRules);
            if (line.causes.length > 0) {
                TreeItem causes = this.doCauses(new HTML("<b>" + Constants.INSTANCE.Causes() + ":</b>"), line.causes);
                report.addItem(causes);
                causes.setState(true);
            }
            this.addItem(report);
        }
        this.setState(true);
    }

    private TreeItem doImpactedRules(AnalysisReportLine line) {
        TreeItem impactedRules = new TreeItem((Widget)new HTML("<b>" + Constants.INSTANCE.ImpactedRules() + ":</b>&nbsp;"));
        for (String ruleAssetGuid : line.impactedRules.keySet()) {
            HorizontalPanel rule = new HorizontalPanel();
            Image image = new Image(DroolsGuvnorImageResources.INSTANCE.ruleAsset());
            image.setAltText("");
            rule.add((Widget)image);
            rule.add((Widget)new Label((String)line.impactedRules.get(ruleAssetGuid)));
            impactedRules.addItem((Widget)rule);
        }
        return impactedRules;
    }

    private TreeItem doCauses(HTML title, Cause[] causes) {
        TreeItem treeItem = new TreeItem((Widget)title);
        for (Cause cause : causes) {
            treeItem.addItem(this.doCauses(new HTML(cause.getCause()), cause.getCauses()));
        }
        return treeItem;
    }
}

