/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import java.util.HashMap;
import java.util.List;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldDataConstraintEditor;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.CollectionFieldData;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class FieldConstraintHelper {
    private final Scenario scenario;
    private final ExecutionTrace executionTrace;
    private final SuggestionCompletionEngine sce;
    private final String factType;
    private Field field;
    private final Fact fact;
    private boolean parentIsAList = false;

    public FieldConstraintHelper(Scenario scenario, ExecutionTrace executionTrace, SuggestionCompletionEngine sce, String factType, Field field, Fact fact) {
        this.scenario = scenario;
        this.executionTrace = executionTrace;
        this.sce = sce;
        this.factType = factType;
        this.field = field;
        this.fact = fact;
    }

    boolean isThereABoundVariableToSet() {
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        if (vars.size() > 0) {
            for (int i = 0; i < vars.size(); ++i) {
                if (!((FactData)this.scenario.getFactTypes().get(vars.get(i))).getType().equals(this.resolveFieldType())) continue;
                return true;
            }
        }
        return false;
    }

    String resolveFieldType() {
        ModelField modelField = this.sce.getField(this.factType, this.field.getName());
        if (modelField == null) {
            return null;
        }
        if (modelField.getType().equals("Collection")) {
            return this.sce.getParametricFieldType(this.factType, this.field.getName());
        }
        return modelField.getType();
    }

    boolean isItAList() {
        String fieldType = this.sce.getFieldType(this.factType, this.field.getName());
        return fieldType != null && fieldType.equals("Collection");
    }

    List<String> getFactNamesInScope() {
        return this.scenario.getFactNamesInScope(this.executionTrace, true);
    }

    FactData getFactTypeByVariableName(String var) {
        return (FactData)this.scenario.getFactTypes().get(var);
    }

    String getFullFieldName() {
        return this.factType + "." + this.field.getName();
    }

    DropDownData getEnums() {
        HashMap<String, String> currentValueMap = new HashMap<String, String>();
        for (Field f : this.fact.getFieldData()) {
            if (!(f instanceof FieldData)) continue;
            FieldData otherFieldData = (FieldData)f;
            currentValueMap.put(otherFieldData.getName(), otherFieldData.getValue());
        }
        return this.sce.getEnums(this.factType, this.field.getName(), currentValueMap);
    }

    String getFieldType() {
        return this.sce.getFieldType(this.getFullFieldName());
    }

    public FieldDataConstraintEditor createFieldDataConstraintEditor(FieldData fieldData) {
        return new FieldDataConstraintEditor(this.factType, fieldData, this.fact, this.sce, this.scenario, this.executionTrace);
    }

    public void replaceFieldWith(Field newField) {
        boolean notCollection = true;
        for (Field factsField : this.fact.getFieldData()) {
            if (!(factsField instanceof CollectionFieldData)) continue;
            CollectionFieldData fData = (CollectionFieldData)factsField;
            notCollection = false;
            List list = fData.getCollectionFieldList();
            boolean aNewItem = true;
            for (FieldData aField : list) {
                if (aField.getNature() != 0L) continue;
                aNewItem = false;
                aField.setNature(((FieldData)newField).getNature());
            }
            if (!aNewItem) continue;
            list.set(list.indexOf(this.field), (FieldData)newField);
        }
        if (notCollection) {
            this.fact.getFieldData().set(this.fact.getFieldData().indexOf(this.field), newField);
            this.field = newField;
        }
    }

    public boolean isDependentEnum(FieldConstraintHelper child) {
        if (!this.fact.getType().equals(child.fact.getType())) {
            return false;
        }
        return this.sce.isDependentEnum(this.fact.getType(), this.field.getName(), child.field.getName());
    }

    public boolean isTheParentAList() {
        return this.parentIsAList;
    }

    public void setParentIsAList(boolean parentIsAList) {
        this.parentIsAList = parentIsAList;
    }
}

