/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.repository.AssetItem;

public class GuidedDTContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(Asset asset, AssetItem item) throws SerializationException {
        GuidedDecisionTable52 model = GuidedDTXMLPersistence.getInstance().unmarshal(item.getContent());
        asset.setContent((PortableObject)model);
    }

    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
        GuidedDecisionTable52 data = (GuidedDecisionTable52)asset.getContent();
        if (data.getTableName() == null) {
            data.setTableName(repoAsset.getName());
        }
        repoAsset.updateContent(GuidedDTXMLPersistence.getInstance().marshal(data));
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        String drl = this.getRawDRL(asset);
        if (drl.equals("")) {
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    public void assembleDRL(BRMSPackageBuilder builder, Asset asset, StringBuilder stringBuilder) {
        String drl = this.getSourceDRL((GuidedDecisionTable52)asset.getContent(), builder);
        stringBuilder.append(drl);
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuilder stringBuilder) {
        String drl = this.getSourceDRL(this.buildModelFromAsset(asset), builder);
        stringBuilder.append(drl);
    }

    private String getSourceDRL(GuidedDecisionTable52 model, BRMSPackageBuilder builder) {
        String drl = GuidedDTDRLPersistence.getInstance().marshal(model);
        if (builder.hasDSL() && model.hasDSLSentences()) {
            drl = builder.getDSLExpander().expand(drl);
        }
        return drl;
    }

    protected GuidedDecisionTable52 buildModelFromAsset(AssetItem asset) {
        GuidedDecisionTable52 model = GuidedDTXMLPersistence.getInstance().unmarshal(asset.getContent());
        model.setTableName(asset.getName());
        model.setParentName(this.parentNameFromCategory(asset, model.getParentName()));
        return model;
    }

    public String getRawDRL(AssetItem asset) {
        return GuidedDTDRLPersistence.getInstance().marshal(this.buildModelFromAsset(asset));
    }
}

