/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.TableDataResult;

public class GlobalAreaAssetSelector
extends Composite {
    public static String currentlySelectedAsset;
    private ListBox assetList = new ListBox();
    private String[] formats;

    public GlobalAreaAssetSelector(String formatToImport) {
        this.formats = formatToImport == null ? new String[]{"brl", "dslr", "drl", "xls", "gdst"} : new String[]{formatToImport};
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                GlobalAreaAssetSelector.this.loadAssetList();
            }
        });
        this.initWidget((Widget)this.assetList);
    }

    private void loadAssetList() {
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        assetService.listAssetsWithPackageName("globalArea", this.formats, 0, -1, "rulelist", (AsyncCallback<TableDataResult>)new GenericCallback<TableDataResult>(){

            public void onSuccess(TableDataResult result) {
                for (int i = 0; i < result.data.length; ++i) {
                    GlobalAreaAssetSelector.this.assetList.addItem(result.data[i].getDisplayName(), result.data[i].id);
                    if (currentlySelectedAsset == null || !result.data[i].equals(currentlySelectedAsset)) continue;
                    GlobalAreaAssetSelector.this.assetList.setSelectedIndex(i);
                }
                GlobalAreaAssetSelector.this.assetList.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent sender) {
                        currentlySelectedAsset = GlobalAreaAssetSelector.this.getSelectedAsset();
                    }
                });
            }

            @Override
            public void onFailure(Throwable t) {
                if (t.getMessage().indexOf("AuthorizationException") <= -1) {
                    super.onFailure(t);
                }
            }
        });
    }

    public String getSelectedAsset() {
        return this.assetList.getItemText(this.assetList.getSelectedIndex());
    }
}

