/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import java.util.Date;
import org.drools.guvnor.client.common.DateTextBox;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.resources.ImagesCore;

public class PopupDatePicker
extends Composite
implements HasValue<Date>,
HasValueChangeHandlers<Date> {
    private final TextBox txtDate;
    private final PopupPanel panel;
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);
    private static final ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private Date date;
    private final DatePicker datePicker;
    private final DateTimeFormat format;
    private final boolean allowEmptyValue;

    public PopupDatePicker(final boolean allowEmptyValue) {
        HorizontalPanel container = new HorizontalPanel();
        this.allowEmptyValue = allowEmptyValue;
        this.txtDate = new DateTextBox(allowEmptyValue);
        this.txtDate.setVisibleLength(DATE_FORMAT.length());
        this.format = DateTimeFormat.getFormat((String)DATE_FORMAT);
        this.datePicker = new DatePicker();
        this.panel = new PopupPanel(true, true){

            protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                if (512 == event.getTypeInt() && event.getNativeEvent().getKeyCode() == 27) {
                    PopupDatePicker.this.panel.hide();
                }
            }
        };
        this.panel.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                PopupDatePicker.this.setValue(PopupDatePicker.this.datePicker.getValue());
            }
        });
        this.datePicker.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                PopupDatePicker.this.setValue((Date)event.getValue());
                PopupDatePicker.this.panel.hide();
            }
        });
        this.panel.add((Widget)this.datePicker);
        Image imgCalendar = new Image(images.calendar());
        imgCalendar.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PopupDatePicker.this.datePicker.setValue(PopupDatePicker.this.getValue());
                PopupDatePicker.this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                    public void setPosition(int offsetWidth, int offsetHeight) {
                        PopupDatePicker.this.panel.setPopupPosition(PopupDatePicker.this.txtDate.getAbsoluteLeft(), PopupDatePicker.this.txtDate.getAbsoluteTop() + PopupDatePicker.this.txtDate.getOffsetHeight());
                    }
                });
            }
        });
        this.txtDate.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                String value = PopupDatePicker.this.txtDate.getText();
                try {
                    PopupDatePicker.this.setValue(DATE_FORMATTER.parseStrict(PopupDatePicker.this.txtDate.getText()));
                }
                catch (IllegalArgumentException iae) {
                    if ("".equals(value) && allowEmptyValue) {
                        PopupDatePicker.this.setValue((Date)null);
                    }
                    PopupDatePicker.this.setValue(new Date());
                }
            }
        });
        container.add((Widget)this.txtDate);
        container.add((Widget)imgCalendar);
        this.initWidget((Widget)container);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.datePicker.addValueChangeHandler(handler);
    }

    public Date getValue() {
        return this.date;
    }

    public void setValue(Date value) {
        this.setValue(value, true);
    }

    public void setValue(Date value, boolean fireEvents) {
        this.date = value;
        if (value != null) {
            this.datePicker.setValue(value, true);
            this.txtDate.setText(this.format.format(value));
        } else {
            this.txtDate.setText("");
        }
    }

    public void setValue(String value) {
        this.setValue(value, true);
    }

    public void setValue(String value, boolean fireEvents) {
        try {
            this.setValue(DATE_FORMATTER.parseStrict(value));
        }
        catch (IllegalArgumentException iae) {
            if ("".equals(value) && this.allowEmptyValue) {
                this.setValue((Date)null);
            }
            this.setValue(new Date());
        }
    }

    public static String convertToString(ValueChangeEvent<Date> event) {
        if (event == null || event.getValue() == null) {
            return "";
        }
        return DATE_FORMATTER.format((Date)event.getValue());
    }
}

