/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.IsWidget;
import org.drools.guvnor.client.asseteditor.RuleViewerWrapper;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.RefreshModuleDataModelEvent;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.util.Activity;

public class AssetEditorActivity
extends Activity {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private final AssetEditorPlace place;
    private final ClientFactory clientFactory;
    private EventBus eventBus;

    public AssetEditorActivity(AssetEditorPlace place, ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.place = place;
    }

    @Override
    public void start(AcceptItem tabbedPanel, EventBus eventBus) {
        this.eventBus = eventBus;
        final boolean[] loading = new boolean[]{true};
        Timer t = new Timer(){

            public void run() {
                if (loading[0]) {
                    LoadingPopup.showMessage(AssetEditorActivity.this.constants.LoadingAsset());
                }
            }
        };
        t.schedule(200);
        this.loadRuleAsset(tabbedPanel, this.place.getUuid(), loading);
    }

    private void loadRuleAsset(AcceptItem tabbedPanel, String uuid, boolean[] loading) {
        this.clientFactory.getAssetService().loadRuleAsset(uuid, this.createGenericCallback(tabbedPanel, loading));
    }

    private GenericCallback<Asset> createGenericCallback(final AcceptItem tabbedPanel, final boolean[] loading) {
        return new GenericCallback<Asset>(){

            public void onSuccess(Asset ruleAsset) {
                AssetEditorActivity.this.eventBus.fireEvent((GwtEvent)new RefreshModuleDataModelEvent(ruleAsset.metaData.moduleName, this.createOnRefreshModuleDataModelCompletion(loading, ruleAsset)));
            }

            private Command createOnRefreshModuleDataModelCompletion(final boolean[] loading2, final Asset ruleAsset) {
                return new Command(){

                    public void execute() {
                        loading2[0] = false;
                        tabbedPanel.add(ruleAsset.getName(), (IsWidget)new RuleViewerWrapper(AssetEditorActivity.this.clientFactory, AssetEditorActivity.this.eventBus, ruleAsset));
                        LoadingPopup.close();
                    }
                };
            }
        };
    }
}

