/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.CategoryService;
import org.drools.guvnor.client.rpc.CategoryServiceAsync;
import org.drools.guvnor.client.widgets.categorynav.CategoryEditor;
import org.drools.guvnor.client.widgets.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.widgets.categorynav.CategorySelectHandler;

public class CategoryManager
extends Composite {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    public VerticalPanel layout = new VerticalPanel();
    private CategoryExplorerWidget explorer;

    public CategoryManager() {
        PrettyFormLayout form = new PrettyFormLayout();
        form.addHeader(GuvnorImages.INSTANCE.EditCategories(), (Widget)new HTML(this.constants.EditCategories()));
        form.startSection(this.constants.CategoriesPurposeTip());
        this.explorer = new CategoryExplorerWidget(new CategorySelectHandler(){

            @Override
            public void selected(String sel) {
            }
        });
        SimplePanel editable = new SimplePanel();
        editable.add((Widget)this.explorer);
        form.addAttribute(this.constants.CurrentCategories(), (Widget)editable);
        HorizontalPanel actions = new HorizontalPanel();
        form.addAttribute("", (Widget)actions);
        Button newCat = new Button(this.constants.NewCategory());
        newCat.setTitle(this.constants.CreateANewCategory());
        newCat.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                CategoryEditor newCat = new CategoryEditor(CategoryManager.this.explorer.getSelectedPath(), new Command(){

                    public void execute() {
                        CategoryManager.this.explorer.refresh();
                    }
                });
                newCat.show();
            }
        });
        actions.add((Widget)newCat);
        Button rename = new Button(this.constants.RenameSelected());
        rename.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (!CategoryManager.this.explorer.isSelected()) {
                    Window.alert((String)CategoryManager.this.constants.PleaseSelectACategoryToRename());
                    return;
                }
                CategoryManager.this.renameSelected();
            }
        });
        actions.add((Widget)rename);
        Button delete = new Button(this.constants.DeleteSelected());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (!CategoryManager.this.explorer.isSelected()) {
                    Window.alert((String)CategoryManager.this.constants.PleaseSelectACategoryToDelete());
                    return;
                }
                CategoryManager.this.deleteSelected();
            }
        });
        delete.setTitle(this.constants.DeleteSelectedCat());
        actions.add((Widget)delete);
        form.endSection();
        this.initWidget((Widget)form);
    }

    private void renameSelected() {
        String name = Window.prompt((String)this.constants.CategoryNewNamePleaseEnter(), (String)"");
        if (name != null) {
            CategoryServiceAsync categoryService = (CategoryServiceAsync)GWT.create(CategoryService.class);
            categoryService.renameCategory(this.explorer.getSelectedPath(), name, new GenericCallback<Void>(){

                public void onSuccess(Void v) {
                    Window.alert((String)CategoryManager.this.constants.CategoryRenamed());
                    CategoryManager.this.explorer.refresh();
                }
            });
        }
    }

    private void deleteSelected() {
        if (Window.confirm((String)(this.constants.AreYouSureYouWantToDeleteCategory() + this.explorer.getSelectedPath()))) {
            CategoryServiceAsync categoryService = (CategoryServiceAsync)GWT.create(CategoryService.class);
            categoryService.removeCategory(this.explorer.getSelectedPath(), new GenericCallback<Void>(){

                public void onSuccess(Void v) {
                    CategoryManager.this.explorer.refresh();
                }
            });
        }
    }
}

