/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.AssetViewerActivityView;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.util.LazyStackPanel;
import org.drools.guvnor.client.util.LoadContentCommand;
import org.drools.guvnor.client.util.Util;
import org.drools.guvnor.client.widgets.tables.AssetPagedTable;

public class AssetViewerActivityViewImpl
extends Composite
implements AssetViewerActivityView {
    private static final ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static AssetViewerActivityViewImplBinder uiBinder = (AssetViewerActivityViewImplBinder)GWT.create(AssetViewerActivityViewImplBinder.class);
    @UiField
    VerticalPanel assetGroupsContainer;
    @UiField
    HorizontalPanel msgNoAssetsDefinedInPackage;

    public AssetViewerActivityViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void showLoadingPackageInformationMessage() {
        LoadingPopup.showMessage(constants.LoadingPackageInformation());
    }

    @Override
    public void closeLoadingPackageInformationMessage() {
        LoadingPopup.close();
    }

    @Override
    public void addAssetFormat(final List<String> formatsInList, final Boolean formatIsRegistered, String title, Image icon, final Module packageConfigData, final ClientFactory clientFactory) {
        LazyStackPanel lsp = new LazyStackPanel();
        lsp.add(title, icon, new LoadContentCommand(){

            @Override
            public Widget load() {
                return AssetViewerActivityViewImpl.this.makeTable(formatsInList, formatIsRegistered, packageConfigData, clientFactory);
            }
        });
        this.assetGroupsContainer.add((Widget)lsp);
    }

    @Override
    public void showHasNoAssetsWarning(boolean isVisible) {
        this.msgNoAssetsDefinedInPackage.setVisible(isVisible);
    }

    private AssetPagedTable makeTable(List<String> formatsInList, Boolean formatIsRegistered, final Module packageConfigData, ClientFactory clientFactory) {
        final AssetPagedTable table = new AssetPagedTable(packageConfigData.getUuid(), formatsInList, formatIsRegistered, this.getFeedUrl(packageConfigData.getName()), clientFactory);
        final ServerPushNotification sub = new ServerPushNotification(){

            @Override
            public void messageReceived(PushResponse response) {
                if (response.messageType.equals("packageChange") && response.message.equals(packageConfigData.getName())) {
                    table.refresh();
                }
            }
        };
        PushClient.instance().subscribe(sub);
        table.addUnloadListener(new Command(){

            public void execute() {
                PushClient.instance().unsubscribe(sub);
            }
        });
        return table;
    }

    private String getFeedUrl(String packageName) {
        return GWT.getModuleBaseURL() + "feed/package?name=" + packageName + "&viewUrl=" + Util.getSelfURL() + "&status=*";
    }

    static interface AssetViewerActivityViewImplBinder
    extends UiBinder<Widget, AssetViewerActivityViewImpl> {
    }
}

