/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.drools.guvnor.client.asseteditor.RuleViewerWrapper;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;

public class VersionChooser
extends Composite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
    private String packageUUID;
    private String assetName;
    private ListBox versionChooser;
    private List<TableDataRow> versionInfo = new ArrayList<TableDataRow>();
    private String currentVersion;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public VersionChooser(ClientFactory clientFactory, EventBus eventBus, String currentVersion, String pacakgeUUID, String assetName, Command ref) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.packageUUID = pacakgeUUID;
        this.assetName = assetName;
        this.currentVersion = currentVersion;
        VerticalPanel verticalPanel = new VerticalPanel();
        this.versionChooser = new ListBox();
        this.loadHistoryData();
        verticalPanel.add((Widget)this.versionChooser);
        Button open = new Button("View selected version");
        open.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!VersionChooser.this.constants.NoHistory().equalsIgnoreCase(VersionChooser.this.versionChooser.getValue(VersionChooser.this.versionChooser.getSelectedIndex()))) {
                    VersionChooser.this.showVersion(VersionChooser.this.versionChooser.getValue(VersionChooser.this.versionChooser.getSelectedIndex()));
                }
            }
        });
        verticalPanel.add((Widget)open);
        this.initWidget((Widget)verticalPanel);
    }

    protected void loadHistoryData() {
        this.assetService.loadAssetHistory(this.packageUUID, this.assetName, (AsyncCallback<TableDataResult>)new GenericCallback<TableDataResult>(){

            public void onSuccess(TableDataResult table) {
                if (table == null || table.data.length == 0) {
                    VersionChooser.this.versionChooser.addItem(VersionChooser.this.constants.NoHistory());
                    VersionChooser.this.versionInfo.add(null);
                    return;
                }
                TableDataRow[] rows = table.data;
                Arrays.sort(rows, new Comparator<TableDataRow>(){

                    @Override
                    public int compare(TableDataRow r1, TableDataRow r2) {
                        Integer v2 = Integer.valueOf(r2.values[0]);
                        Integer v1 = Integer.valueOf(r1.values[0]);
                        return v2.compareTo(v1);
                    }
                });
                for (TableDataRow row : rows) {
                    String s = VersionChooser.this.constants.property0ModifiedOn1By23(row.values[0], row.values[2], row.values[4], row.values[1]);
                    VersionChooser.this.versionChooser.addItem(s, row.id);
                    VersionChooser.this.versionInfo.add(row);
                }
                VersionChooser.this.selectCurrentVersion(VersionChooser.this.currentVersion);
            }
        });
    }

    public String getSelectedVersionUUID() {
        if (this.versionChooser != null) {
            return this.versionChooser.getValue(this.versionChooser.getSelectedIndex());
        }
        return null;
    }

    private void selectCurrentVersion(String currentVersion) {
        for (int i = 0; i < this.versionInfo.size(); ++i) {
            TableDataRow row = this.versionInfo.get(i);
            if (!row.values[0].equals(currentVersion)) continue;
            this.versionChooser.setSelectedIndex(i);
            break;
        }
    }

    public String getSelectedVersionName() {
        TableDataRow t;
        if (this.versionChooser != null && (t = this.versionInfo.get(this.versionChooser.getSelectedIndex())) != null) {
            return t.values[0];
        }
        return null;
    }

    private void showVersion(String versionUUID) {
        LoadingPopup.showMessage(this.constants.LoadingVersionFromHistory());
        this.assetService.loadRuleAsset(versionUUID, (AsyncCallback<Asset>)new GenericCallback<Asset>(){

            public void onSuccess(Asset asset) {
                asset.setReadonly(true);
                Image image = new Image(images.snapshot());
                image.setAltText(ConstantsCore.INSTANCE.Snapshot());
                FormStylePopup pop = new FormStylePopup(image, VersionChooser.this.constants.VersionNumber0Of1(asset.getVersionNumber(), asset.getName()), 800);
                RuleViewerWrapper viewer = new RuleViewerWrapper(VersionChooser.this.clientFactory, VersionChooser.this.eventBus, asset, true);
                viewer.setWidth("100%");
                viewer.setHeight("100%");
                pop.addRow((Widget)viewer);
                pop.show();
            }
        });
    }
}

