/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.query;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.widgets.tables.QueryPagedTable;

public class QuickFindWidget
extends Composite {
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private SuggestBox searchBox;
    private CheckBox archiveBox;
    private CheckBox caseSensitiveBox;

    public QuickFindWidget(final ClientFactory clientFactory) {
        VerticalPanel container = new VerticalPanel();
        VerticalPanel criteria = new VerticalPanel();
        Image image = new Image(images.systemSearch());
        image.setAltText(constants.SystemSearch());
        FormStyleLayout layout = new FormStyleLayout(image, "");
        this.searchBox = new SuggestBox(new SuggestOracle(){

            public void requestSuggestions(SuggestOracle.Request r, SuggestOracle.Callback cb) {
                QuickFindWidget.this.loadShortList(r.getQuery(), QuickFindWidget.this.archiveBox.getValue(), QuickFindWidget.this.caseSensitiveBox.getValue(), r, cb);
            }
        });
        HorizontalPanel srch = new HorizontalPanel();
        final SimplePanel resultsP = new SimplePanel();
        final ClickHandler cl = new ClickHandler(){

            public void onClick(ClickEvent event) {
                resultsP.clear();
                QueryPagedTable table = new QueryPagedTable(QuickFindWidget.this.searchBox.getValue(), QuickFindWidget.this.archiveBox.getValue(), QuickFindWidget.this.caseSensitiveBox.getValue(), clientFactory);
                resultsP.add((Widget)table);
            }
        };
        this.searchBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    cl.onClick(null);
                }
            }
        });
        srch.add((Widget)this.searchBox);
        layout.addAttribute(constants.FindItemsWithANameMatching(), (Widget)srch);
        this.archiveBox = new CheckBox();
        this.archiveBox.setValue(Boolean.valueOf(false));
        layout.addAttribute(constants.IncludeArchivedAssetsInResults(), (Widget)this.archiveBox);
        this.caseSensitiveBox = new CheckBox();
        this.caseSensitiveBox.setValue(Boolean.valueOf(false));
        layout.addAttribute(constants.IsSearchCaseSensitive(), (Widget)this.caseSensitiveBox);
        Button go = new Button(constants.Search());
        go.addClickHandler(cl);
        layout.addAttribute("", (Widget)go);
        HorizontalPanel searchTitle = new HorizontalPanel();
        searchTitle.add((Widget)new Image(images.information()));
        searchTitle.add((Widget)new Label(constants.EnterSearchString()));
        FlexTable listPanel = new FlexTable();
        listPanel.setWidget(0, 0, (Widget)searchTitle);
        PrettyFormLayout pfl = new PrettyFormLayout();
        pfl.startSection();
        pfl.addRow((Widget)listPanel);
        pfl.endSection();
        criteria.add((Widget)pfl);
        criteria.add((Widget)layout);
        container.add((Widget)criteria);
        container.add((Widget)resultsP);
        this.initWidget((Widget)container);
    }

    protected void loadShortList(String searchText, Boolean searchArchived, Boolean isCaseSensitive, final SuggestOracle.Request r, final SuggestOracle.Callback cb) {
        QueryPageRequest queryRequest = new QueryPageRequest(searchText, searchArchived, isCaseSensitive, 0, 5);
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        assetService.quickFindAsset(queryRequest, (AsyncCallback<PageResponse<QueryPageRow>>)new GenericCallback<PageResponse<QueryPageRow>>(){

            public void onSuccess(PageResponse<QueryPageRow> result) {
                ArrayList<1> items = new ArrayList<1>();
                for (QueryPageRow row : result.getPageRowList()) {
                    final String name = row.getName();
                    items.add(new SuggestOracle.Suggestion(){

                        public String getDisplayString() {
                            return name;
                        }

                        public String getReplacementString() {
                            return name;
                        }
                    });
                }
                cb.onSuggestionsReady(r, new SuggestOracle.Response(items));
            }
        });
    }
}

