/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.jboss.seam.security.Identity;

public class PermissionPageRowBuilder
implements PageRowBuilder<PageRequest, Map<String, List<String>>> {
    private PageRequest pageRequest;
    private Map<String, List<String>> permissions;
    private Identity identity;

    @Override
    public List<PermissionsPageRow> build() {
        this.validate();
        int rowMinNumber = this.pageRequest.getStartRowIndex();
        int rowMaxNumber = this.pageRequest.getPageSize() == null ? this.permissions.size() : rowMinNumber + this.pageRequest.getPageSize();
        int resultsSize = this.pageRequest.getPageSize() == null ? this.permissions.size() : this.pageRequest.getPageSize().intValue();
        ArrayList<PermissionsPageRow> rowList = new ArrayList<PermissionsPageRow>(resultsSize);
        Iterator<String> mapItr = this.permissions.keySet().iterator();
        for (int rowNumber = 0; mapItr.hasNext() && rowNumber < rowMaxNumber; ++rowNumber) {
            String userName = mapItr.next();
            if (rowNumber < rowMinNumber) continue;
            List<String> userPermissions = this.permissions.get(userName);
            PermissionsPageRow row = new PermissionsPageRow();
            row.setUserName(userName);
            row.setUserPermissions(userPermissions);
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.permissions == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public PermissionPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public PermissionPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public PermissionPageRowBuilder withContent(Map<String, List<String>> permissions) {
        this.permissions = permissions;
        return this;
    }
}

