/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRow;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.jboss.seam.security.Identity;

public class SnapshotComparisonPageRowBuilder
implements PageRowBuilder<PageRequest, SnapshotDiffs> {
    private SnapshotDiffs diffs;
    private PageRequest pageRequest;
    private Identity identity;

    @Override
    public List<SnapshotComparisonPageRow> build() {
        this.validate();
        ArrayList<SnapshotComparisonPageRow> rowList = new ArrayList<SnapshotComparisonPageRow>();
        int pageStart = this.pageRequest.getStartRowIndex();
        int numRowsToReturn = this.pageRequest.getPageSize() == null ? this.diffs.diffs.length : this.pageRequest.getPageSize();
        int maxRow = Math.min(numRowsToReturn, this.diffs.diffs.length - this.pageRequest.getStartRowIndex());
        for (int i = pageStart; i < pageStart + maxRow; ++i) {
            SnapshotComparisonPageRow pr = new SnapshotComparisonPageRow();
            pr.setDiff(this.diffs.diffs[i]);
            rowList.add(pr);
        }
        return rowList;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.diffs == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public SnapshotComparisonPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public SnapshotComparisonPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SnapshotComparisonPageRowBuilder withContent(SnapshotDiffs diffs) {
        this.diffs = diffs;
        return this;
    }
}

