/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.drools.RuntimeDroolsException;
import org.drools.guvnor.server.files.FileManagerService;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.FormData;
import org.drools.guvnor.server.util.LoggingHelper;

public class RepositoryBackupServlet
extends RepositoryServlet {
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryBackupServlet.class);
    private static final long serialVersionUID = 510L;
    private static final List<String> zipMimeTypes = new ArrayList<String>();
    @Inject
    private FileManagerService fileManagerService;

    protected void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        this.doAuthorizedAction(request, response, new RepositoryServlet.Command(){

            @Override
            public void execute() throws Exception {
                String repoConfig = request.getParameter("repoConfig");
                if (repoConfig != null) {
                    RepositoryBackupServlet.this.processExportRepoConfig(response, repoConfig);
                } else {
                    response.setContentType("text/html");
                    FormData uploadItem = FileManagerService.getFormData(request);
                    String packageImport = request.getParameter("packageImport");
                    InputStream is = uploadItem.getFile().getInputStream();
                    if (RepositoryBackupServlet.this.isFileZipped(uploadItem.getFile())) {
                        ZipInputStream zipInputStream = new ZipInputStream(is);
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (zipEntry != null) {
                            is = zipInputStream;
                        } else {
                            throw new RuntimeDroolsException("Invalid compressed repository");
                        }
                    }
                    if ("true".equals(packageImport)) {
                        boolean importAsNew = "true".equals(request.getParameter("importAsNew"));
                        response.getWriter().write(RepositoryBackupServlet.this.processImportPackage(is, importAsNew));
                    } else {
                        response.getWriter().write(RepositoryBackupServlet.this.processImportRepository(is));
                    }
                    is.close();
                }
            }
        });
    }

    private boolean isFileZipped(FileItem file) throws IOException {
        String mimeType = file.getContentType().toLowerCase();
        return zipMimeTypes.contains(mimeType);
    }

    protected void doGet(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, new RepositoryServlet.Command(){

            @Override
            public void execute() throws Exception {
                try {
                    String packageName = req.getParameter("packageName");
                    if (packageName == null) {
                        RepositoryBackupServlet.this.processExportRepositoryDownload(res);
                    } else if (RepositoryBackupServlet.this.fileManagerService.isPackageExist(packageName)) {
                        RepositoryBackupServlet.this.processExportPackageFromRepositoryDownload(res, packageName);
                    } else {
                        res.setContentType("text/plain");
                        res.setStatus(500);
                        res.getWriter().write("Package [" + packageName + "] does not exist");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(new PrintWriter((OutputStream)res.getOutputStream()));
                }
            }
        });
    }

    private void processExportRepoConfig(HttpServletResponse res, String repoConfig) throws IOException {
        log.debug("Exporting Repository Config...");
        res.setContentType("application/x-download");
        res.setHeader("Content-Disposition", "attachment; filename=repository.xml;");
        log.debug("Starting to process repository configuration");
        res.getOutputStream().write(repoConfig.getBytes());
        res.getOutputStream().flush();
        log.debug("Done exporting repository config!");
    }

    private void processExportRepositoryDownload(HttpServletResponse res) throws PathNotFoundException, IOException, RepositoryException {
        log.debug("Exporting...");
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "attachment; filename=repository_export.zip;");
        log.debug("Starting to process export");
        ZipOutputStream zout = new ZipOutputStream((OutputStream)res.getOutputStream());
        zout.putNextEntry(new ZipEntry("repository_export.xml"));
        this.fileManagerService.exportRulesRepository(zout);
        zout.closeEntry();
        zout.finish();
        res.getOutputStream().flush();
        log.debug("Done exporting!");
    }

    private void processExportPackageFromRepositoryDownload(HttpServletResponse res, String packageName) throws PathNotFoundException, IOException, RepositoryException {
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "inline; filename=" + packageName + ".zip;");
        res.getOutputStream().write(this.fileManagerService.exportPackageFromRepository(packageName));
        res.getOutputStream().flush();
    }

    private String processImportRepository(InputStream file) throws IOException {
        this.fileManagerService.importRulesRepository(file);
        return "OK";
    }

    private String processImportPackage(InputStream file, boolean importAsNew) throws IOException {
        byte[] byteArray = new byte[file.available()];
        file.read(byteArray);
        this.fileManagerService.importPackageToRepository(byteArray, importAsNew);
        return "OK";
    }

    static {
        zipMimeTypes.add("application/zip");
        zipMimeTypes.add("application/x-compress");
        zipMimeTypes.add("application/x-compressed");
        zipMimeTypes.add("application/x-zip");
        zipMimeTypes.add("application/x-zip-compressed");
        zipMimeTypes.add("application/zip-compressed");
        zipMimeTypes.add("application/x-7zip-compressed");
        zipMimeTypes.add("application/x-sdlc");
    }
}

