/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.AuthorizationHeaderChecker;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.repository.RulesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 510L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    @Preferred
    protected RulesRepository rulesRepository;
    @Inject
    protected AuthorizationHeaderChecker authorizationHeaderChecker;

    void doAuthorizedAction(HttpServletRequest req, HttpServletResponse res, Command action) throws IOException {
        String auth = req.getHeader("Authorization");
        if (!this.authorizationHeaderChecker.loginByHeader(auth)) {
            res.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
            res.sendError(401);
        } else {
            try {
                action.execute();
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    static interface Command {
        public void execute() throws Exception;
    }
}

