/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GuvnorBootstrapConfiguration {
    private static final String ADMIN_USERNAME_DEFAULT = "admin";
    private static final String ADMIN_USERNAME_PROPERTY = "org.drools.repository.admin.username";
    private static final String ADMIN_PASSWORD_DEFAULT = "password";
    private static final String ADMIN_PASSWORD_PROPERTY = "org.drools.repository.admin.password";
    public static final String MAILMAN_USERNAME_DEFAULT = "mailman";
    private static final String MAILMAN_USERNAME_PROPERTY = "org.drools.repository.mailman.username";
    private static final String MAILMAN_PASSWORD_DEFAULT = "password";
    private static final String MAILMAN_PASSWORD_PROPERTY = "org.drools.repository.mailman.password";
    private static final String SECURE_PASSWORDS_PROPERTY = "org.drools.repository.secure.passwords";
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> properties = new HashMap<String, String>();

    public GuvnorBootstrapConfiguration() {
        Properties props = new Properties();
        try {
            URL res = this.getClass().getResource("/guvnor-bootstrap.properties");
            if (res != null) {
                props.load(res.openStream());
            }
        }
        catch (IOException e) {
            this.log.error("Problem reading properties file");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.setProperties(map);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @PostConstruct
    public void validate() {
        if (!this.properties.containsKey("org.drools.repository.configurator")) {
            throw new IllegalStateException("The beans.xml file does not have a GuvnorBootstrapConfiguration with a property for the configurator class (org.drools.repository.configurator) configured.");
        }
    }

    public String extractAdminUsername() {
        if (!this.properties.containsKey(ADMIN_USERNAME_PROPERTY)) {
            return ADMIN_USERNAME_DEFAULT;
        }
        return this.properties.get(ADMIN_USERNAME_PROPERTY);
    }

    public String extractAdminPassword() {
        if (!this.properties.containsKey(ADMIN_PASSWORD_PROPERTY)) {
            this.log.debug("Could not find property org.drools.repository.admin.password for user admin");
            return "password";
        }
        String password = this.properties.get(ADMIN_PASSWORD_PROPERTY);
        if ("true".equalsIgnoreCase(this.properties.get(SECURE_PASSWORDS_PROPERTY))) {
            password = this.decode(password);
        }
        return password;
    }

    public String extractMailmanUsername() {
        if (!this.properties.containsKey(MAILMAN_USERNAME_PROPERTY)) {
            return MAILMAN_USERNAME_DEFAULT;
        }
        return this.properties.get(MAILMAN_USERNAME_PROPERTY);
    }

    public String extractMailmanPassword() {
        if (!this.properties.containsKey(MAILMAN_PASSWORD_PROPERTY)) {
            this.log.debug("Could not find property org.drools.repository.mailman.password for user mailman");
            return "password";
        }
        String password = this.properties.get(MAILMAN_PASSWORD_PROPERTY);
        if ("true".equalsIgnoreCase(this.properties.get(SECURE_PASSWORDS_PROPERTY))) {
            password = this.decode(password);
        }
        return password;
    }

    private String decode(String secret) {
        String decodedPassword = secret;
        try {
            byte[] kbytes = "jaas is the way".getBytes();
            SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
            BigInteger n = new BigInteger(secret, 16);
            byte[] encoding = n.toByteArray();
            if (encoding.length % 8 != 0) {
                int length = encoding.length;
                int newLength = (length / 8 + 1) * 8;
                int pad = newLength - length;
                byte[] old = encoding;
                encoding = new byte[newLength];
                for (int i = old.length - 1; i >= 0; --i) {
                    encoding[i + pad] = old[i];
                }
            }
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, key);
            byte[] decode = cipher.doFinal(encoding);
            decodedPassword = new String(decode);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return decodedPassword;
    }
}

