/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.standalonededitor;

import com.google.gwt.user.client.rpc.SerializationException;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.standalonededitor.RuleAssetProvider;

public class NewRuleAssetProvider
implements RuleAssetProvider {
    private final String packageName;
    private final String categoryName;
    private final String assetName;
    private final String assetFormat;
    private final ServiceImplementation serviceImplementation;
    private final RepositoryAssetService repositoryAssetService;

    public NewRuleAssetProvider(String packageName, String categoryName, String assetName, String assetFormat, ServiceImplementation serviceImplementation, RepositoryAssetService repositoryAssetService) {
        this.packageName = packageName;
        this.categoryName = categoryName;
        this.assetName = assetName;
        this.assetFormat = assetFormat != null ? assetFormat : "brl";
        this.serviceImplementation = serviceImplementation;
        this.repositoryAssetService = repositoryAssetService;
    }

    @Override
    public Asset[] getRuleAssets() throws DetailedSerializationException {
        try {
            String ruleUUID = this.serviceImplementation.createNewRule(this.assetName, "created by standalone editor", this.categoryName, this.packageName, this.assetFormat);
            Asset newRule = this.repositoryAssetService.loadRuleAsset(ruleUUID);
            return new Asset[]{newRule};
        }
        catch (SerializationException ex) {
            throw new DetailedSerializationException("Error creating rule asset", ex.getMessage());
        }
    }
}

