/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.shared.modules;

import java.util.Iterator;
import org.drools.guvnor.shared.modules.ModuleHeader;

public class ModuleHeaderHelper {
    public static ModuleHeader parseHeader(String header) {
        if (header == null || header.equals("")) {
            ModuleHeader mh = new ModuleHeader();
            return mh;
        }
        ModuleHeader mh = new ModuleHeader();
        String[] lines = header.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String tk = lines[i].trim();
            if (tk.equals("") || tk.startsWith("#")) continue;
            if (tk.startsWith("import")) {
                if ((tk = tk.substring(6).trim()).endsWith(";")) {
                    tk = tk.substring(0, tk.length() - 1);
                }
                mh.getImports().add(new ModuleHeader.Import(tk));
                continue;
            }
            if (tk.startsWith("global")) {
                if ((tk = tk.substring(6).trim()).endsWith(";")) {
                    tk = tk.substring(0, tk.length() - 1);
                }
                String[] gt = tk.split("\\s+");
                mh.getGlobals().add(new ModuleHeader.Global(gt[0], gt[1]));
                continue;
            }
            if (tk.startsWith("rule")) {
                mh.setHasRules(true);
                return mh;
            }
            if (tk.startsWith("declare")) {
                mh.setHasDeclaredTypes(true);
                return mh;
            }
            if (tk.startsWith("function")) {
                mh.setHasFunctions(true);
                return mh;
            }
            return null;
        }
        return mh;
    }

    public static String renderModuleHeader(ModuleHeader mh) {
        StringBuilder sb = new StringBuilder();
        for (ModuleHeader.Import i : mh.getImports()) {
            sb.append("import " + i.getType() + "\n");
        }
        Iterator<ModuleHeader.Global> it = mh.getGlobals().iterator();
        while (it.hasNext()) {
            ModuleHeader.Global g = it.next();
            sb.append("global " + g.getType() + " " + g.getName());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

