/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class VersionedAssetItemIterator
extends AssetItemIterator {
    Map<String, String> dependencyVersionMap = new HashMap<String, String>();
    private boolean returnAssetsWithVersionsSpecifiedByDependencies = false;

    public VersionedAssetItemIterator(NodeIterator nodes, RulesRepository repo, String[] dependencies) {
        super(nodes, repo);
        for (String dependency : dependencies) {
            String[] decodedPath = ModuleItem.decodeDependencyPath(dependency);
            if ("LATEST".equals(decodedPath[1])) continue;
            this.dependencyVersionMap.put(decodedPath[0], decodedPath[1]);
        }
    }

    @Override
    public AssetItem next() {
        AssetItem ai = super.next();
        if (this.returnAssetsWithVersionsSpecifiedByDependencies && this.dependencyVersionMap.get(ai.getName()) != null) {
            String version = this.dependencyVersionMap.get(ai.getName());
            return this.loadAssetWithVersion(ai, version);
        }
        return ai;
    }

    public void setReturnAssetsWithVersionsSpecifiedByDependencies(boolean flag) {
        this.returnAssetsWithVersionsSpecifiedByDependencies = flag;
    }

    protected AssetItem loadAssetWithVersion(AssetItem assetItem, String version) {
        long requiredVersion = Long.parseLong(version);
        if (assetItem.isHistoricalVersion()) {
            long currentVersion = assetItem.getVersionNumber();
            if (requiredVersion == currentVersion) {
                return assetItem;
            }
            Node frozenNode = assetItem.getNode();
            try {
                Node headNode = frozenNode.getSession().getNodeByIdentifier(frozenNode.getProperty("jcr:frozenUuid").getString());
                AssetHistoryIterator historyIterator = new AssetHistoryIterator(assetItem.getRulesRepository(), headNode);
                while (historyIterator.hasNext()) {
                    AssetItem historical = historyIterator.next();
                    if (requiredVersion != historical.getVersionNumber()) continue;
                    return historical;
                }
            }
            catch (RepositoryException e) {
                throw new RulesRepositoryException("Unable to load AssetItem[" + assetItem.getName() + "] with specificed version[" + version + "]", e);
            }
        } else {
            AssetHistoryIterator it = assetItem.getHistory();
            while (it.hasNext()) {
                AssetItem historical = it.next();
                if (requiredVersion != historical.getVersionNumber()) continue;
                return historical;
            }
        }
        throw new RulesRepositoryException("Unable to load AssetItem[" + assetItem.getName() + "] with specificed version[" + version + "]");
    }
}

