/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.servlet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialRouterAPI;
import org.kie.uberfire.social.activities.service.SocialTimeLineRepositoryAPI;
import org.kie.uberfire.social.activities.servlet.AtomSocialTimelineConverter;

public class SocialTimeLineServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Inject
    SocialTimeLineRepositoryAPI timeLineRepositoryAPI;
    @Inject
    SocialRouterAPI socialRouter;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SocialAdapter socialAdapter = this.socialRouter.getSocialAdapterByPath(request.getPathInfo());
        Map commandsMap = request.getParameterMap();
        List eventTimeline = this.timeLineRepositoryAPI.getLastEventTimeline(socialAdapter, commandsMap);
        response.setContentType("application/atom+xml");
        String url = "/social" + request.getPathInfo();
        response.getWriter().println(this.createFeed(eventTimeline, url));
    }

    private String createFeed(List<SocialActivitiesEvent> eventTimeline, String url) {
        return AtomSocialTimelineConverter.generate(eventTimeline, url);
    }
}

