/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class AudioSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "samr";
    public static final String TYPE2 = "sawb";
    public static final String TYPE3 = "mp4a";
    public static final String TYPE4 = "drms";
    public static final String TYPE5 = "alac";
    public static final String TYPE7 = "owma";
    public static final String TYPE8 = "ac-3";
    public static final String TYPE9 = "ec-3";
    public static final String TYPE10 = "mlpa";
    public static final String TYPE_ENCRYPTED = "enca";
    private int channelCount;
    private int sampleSize;
    private long sampleRate;
    private int soundVersion;
    private int compressionId;
    private int packetSize;
    private long samplesPerPacket;
    private long bytesPerPacket;
    private long bytesPerFrame;
    private long bytesPerSample;
    private int reserved1;
    private long reserved2;
    private byte[] soundVersion2Data;
    private BoxParser boxParser;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;

    public AudioSampleEntry(String type) {
        super(type);
    }

    public int getChannelCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.channelCount;
    }

    public int getSampleSize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.sampleSize;
    }

    public long getSampleRate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.sampleRate;
    }

    public int getSoundVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.soundVersion;
    }

    public int getCompressionId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.compressionId;
    }

    public int getPacketSize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.packetSize;
    }

    public long getSamplesPerPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.samplesPerPacket;
    }

    public long getBytesPerPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.bytesPerPacket;
    }

    public long getBytesPerFrame() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.bytesPerFrame;
    }

    public long getBytesPerSample() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.bytesPerSample;
    }

    /*
     * WARNING - void declaration
     */
    public void setChannelCount(int n) {
        void channelCount;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.channelCount = channelCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleSize(int n) {
        void sampleSize;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.sampleSize = sampleSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleRate(long l) {
        void sampleRate;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.sampleRate = sampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setSoundVersion(int n) {
        void soundVersion;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.soundVersion = soundVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void setCompressionId(int n) {
        void compressionId;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.compressionId = compressionId;
    }

    /*
     * WARNING - void declaration
     */
    public void setPacketSize(int n) {
        void packetSize;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.packetSize = packetSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setSamplesPerPacket(long l) {
        void samplesPerPacket;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.samplesPerPacket = samplesPerPacket;
    }

    /*
     * WARNING - void declaration
     */
    public void setBytesPerPacket(long l) {
        void bytesPerPacket;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.bytesPerPacket = bytesPerPacket;
    }

    /*
     * WARNING - void declaration
     */
    public void setBytesPerFrame(long l) {
        void bytesPerFrame;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.bytesPerFrame = bytesPerFrame;
    }

    /*
     * WARNING - void declaration
     */
    public void setBytesPerSample(long l) {
        void bytesPerSample;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.bytesPerSample = bytesPerSample;
    }

    /*
     * WARNING - void declaration
     */
    public void setReserved1(int n) {
        void reserved1;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.reserved1 = reserved1;
    }

    /*
     * WARNING - void declaration
     */
    public void setReserved2(long l) {
        void reserved2;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.reserved2 = reserved2;
    }

    /*
     * WARNING - void declaration
     */
    public void setSoundVersion2Data(byte[] byArray) {
        void soundVersion2Data;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)byArray2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.soundVersion2Data = soundVersion2Data;
    }

    /*
     * WARNING - void declaration
     */
    public void setBoxParser(BoxParser boxParser) {
        void boxParser2;
        BoxParser boxParser3 = boxParser;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)boxParser3);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.boxParser = boxParser2;
    }

    public void _parseDetails(ByteBuffer content) {
        this._parseReservedAndDataReferenceIndex(content);
        this.soundVersion = IsoTypeReader.readUInt16(content);
        this.reserved1 = IsoTypeReader.readUInt16(content);
        this.reserved2 = IsoTypeReader.readUInt32(content);
        this.channelCount = IsoTypeReader.readUInt16(content);
        this.sampleSize = IsoTypeReader.readUInt16(content);
        this.compressionId = IsoTypeReader.readUInt16(content);
        this.packetSize = IsoTypeReader.readUInt16(content);
        this.sampleRate = IsoTypeReader.readUInt32(content);
        if (!this.type.equals(TYPE10)) {
            this.sampleRate >>>= 16;
        }
        if (this.soundVersion > 0) {
            this.samplesPerPacket = IsoTypeReader.readUInt32(content);
            this.bytesPerPacket = IsoTypeReader.readUInt32(content);
            this.bytesPerFrame = IsoTypeReader.readUInt32(content);
            this.bytesPerSample = IsoTypeReader.readUInt32(content);
        }
        if (this.soundVersion == 2) {
            this.soundVersion2Data = new byte[20];
            content.get(20);
        }
        this._parseChildBoxes(content);
    }

    protected long getContentSize() {
        long contentSize = 28L;
        contentSize += (long)(this.soundVersion > 0 ? 16 : 0);
        contentSize += (long)(this.soundVersion == 2 ? 20 : 0);
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "AudioSampleEntry";
    }

    protected void getContent(ByteBuffer bb) throws IOException {
        this._writeReservedAndDataReferenceIndex(bb);
        IsoTypeWriter.writeUInt16(bb, this.soundVersion);
        IsoTypeWriter.writeUInt16(bb, this.reserved1);
        IsoTypeWriter.writeUInt32(bb, this.reserved2);
        IsoTypeWriter.writeUInt16(bb, this.channelCount);
        IsoTypeWriter.writeUInt16(bb, this.sampleSize);
        IsoTypeWriter.writeUInt16(bb, this.compressionId);
        IsoTypeWriter.writeUInt16(bb, this.packetSize);
        if (this.type.equals(TYPE10)) {
            IsoTypeWriter.writeUInt32(bb, this.getSampleRate());
        } else {
            IsoTypeWriter.writeUInt32(bb, this.getSampleRate() << 16);
        }
        if (this.soundVersion > 0) {
            IsoTypeWriter.writeUInt32(bb, this.samplesPerPacket);
            IsoTypeWriter.writeUInt32(bb, this.bytesPerPacket);
            IsoTypeWriter.writeUInt32(bb, this.bytesPerFrame);
            IsoTypeWriter.writeUInt32(bb, this.bytesPerSample);
        }
        if (this.soundVersion == 2) {
            bb.put(this.soundVersion2Data);
        }
        this._writeChildBoxes(bb);
    }

    static {
        AudioSampleEntry.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AudioSampleEntry.java", AudioSampleEntry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChannelCount", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "int"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleSize", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "int"), 75);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setChannelCount", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "int", "channelCount", "", "void"), 111);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleSize", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "int", "sampleSize", "", "void"), 115);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleRate", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "long", "sampleRate", "", "void"), 119);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSoundVersion", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "int", "soundVersion", "", "void"), 123);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCompressionId", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "int", "compressionId", "", "void"), 127);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPacketSize", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "int", "packetSize", "", "void"), 131);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSamplesPerPacket", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "long", "samplesPerPacket", "", "void"), 135);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBytesPerPacket", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "long", "bytesPerPacket", "", "void"), 139);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBytesPerFrame", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "long", "bytesPerFrame", "", "void"), 143);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBytesPerSample", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "long", "bytesPerSample", "", "void"), 147);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleRate", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "long"), 79);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReserved1", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "int", "reserved1", "", "void"), 151);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReserved2", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "long", "reserved2", "", "void"), 155);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSoundVersion2Data", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "[B", "soundVersion2Data", "", "void"), 159);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBoxParser", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "com.coremedia.iso.BoxParser", "boxParser", "", "void"), 163);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "java.lang.String"), 219);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSoundVersion", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "int"), 83);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompressionId", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "int"), 87);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPacketSize", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "int"), 91);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSamplesPerPacket", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "long"), 95);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytesPerPacket", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "long"), 99);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytesPerFrame", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "long"), 103);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytesPerSample", "com.coremedia.iso.boxes.sampleentry.AudioSampleEntry", "", "", "", "long"), 107);
    }
}

