/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilterImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompiledPermissionsImpl
extends AbstractCompiledPermissions
implements AccessControlListener {
    private final List<String> principalNames;
    private final SessionImpl session;
    private final EntryCollector entryCollector;
    private final AccessControlUtils util;
    private final Map<ItemId, Boolean> readCache = new GrowingLRUMap(1024, 5000);
    private final Object monitor = new Object();

    CompiledPermissionsImpl(Set<Principal> principals, SessionImpl session, EntryCollector entryCollector, AccessControlUtils util, boolean listenToEvents) throws RepositoryException {
        this.session = session;
        this.entryCollector = entryCollector;
        this.util = util;
        this.principalNames = new ArrayList<String>(principals.size());
        for (Principal princ : principals) {
            this.principalNames.add(princ.getName());
        }
        if (listenToEvents) {
            entryCollector.addListener(this);
        }
    }

    private AbstractCompiledPermissions.Result buildResult(NodeImpl node, boolean isExistingNode, boolean isAcItem, EntryFilterImpl filter) throws RepositoryException {
        NodeImpl n = ACLProvider.getNode(node, isAcItem);
        Iterator<AccessControlEntry> entries = this.entryCollector.collectEntries(n, filter).iterator();
        int allows = 0;
        int denies = 0;
        int allowPrivileges = 0;
        int denyPrivileges = 0;
        int parentAllows = 0;
        int parentDenies = 0;
        String parentPath = Text.getRelativeParent((String)filter.getPath(), (int)1);
        while (entries.hasNext()) {
            int permissions;
            boolean matchesParent;
            ACLTemplate.Entry ace = (ACLTemplate.Entry)entries.next();
            int entryBits = ace.getPrivilegeBits();
            boolean isLocal = isExistingNode && ace.isLocal(node.getNodeId());
            boolean bl = matchesParent = !isLocal && ace.matches(parentPath);
            if (matchesParent) {
                if (ace.isAllow()) {
                    parentAllows |= Permission.diff(entryBits, parentDenies);
                } else {
                    parentDenies |= Permission.diff(entryBits, parentAllows);
                }
            }
            if (ace.isAllow()) {
                permissions = PrivilegeRegistry.calculatePermissions(allowPrivileges |= Permission.diff(entryBits, denyPrivileges), parentAllows, true, isAcItem);
                allows |= Permission.diff(permissions, denies);
                continue;
            }
            permissions = PrivilegeRegistry.calculatePermissions(denyPrivileges |= Permission.diff(entryBits, allowPrivileges), parentDenies, false, isAcItem);
            denies |= Permission.diff(permissions, allows);
        }
        return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
    }

    @Override
    protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
        NodeImpl node;
        boolean existingNode = false;
        ItemManager itemMgr = this.session.getItemManager();
        try {
            ItemImpl item = itemMgr.getItem(absPath);
            if (item.isNode()) {
                node = (NodeImpl)item;
                existingNode = true;
            } else {
                node = (NodeImpl)item.getParent();
            }
        }
        catch (RepositoryException e) {
            int index;
            Name name;
            Path.Element[] elems = absPath.getElements();
            NodeImpl parent = (NodeImpl)this.session.getRootNode();
            for (int i = 1; i < elems.length - 1 && parent.hasNode(name = elems[i].getName(), index = elems[i].getIndex()); ++i) {
                parent = parent.getNode(name, index);
            }
            node = parent;
        }
        if (node == null) {
            throw new ItemNotFoundException("Item out of hierarchy.");
        }
        boolean isAcItem = this.util.isAcItem(absPath);
        return this.buildResult(node, existingNode, isAcItem, new EntryFilterImpl(this.principalNames, absPath, (PathResolver)this.session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearCache() {
        Object object = this.monitor;
        synchronized (object) {
            this.readCache.clear();
        }
        super.clearCache();
    }

    @Override
    public void close() {
        this.entryCollector.removeListener(this);
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
        ItemId id = itemId == null ? this.session.getHierarchyManager().resolvePath(path) : itemId;
        boolean isExistingNode = id.denotesNode();
        boolean canRead = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.readCache.containsKey(id)) {
                canRead = this.readCache.get(id);
            } else {
                ItemManager itemMgr = this.session.getItemManager();
                NodeId nodeId = isExistingNode ? (NodeId)id : ((PropertyId)id).getParentId();
                NodeImpl node = (NodeImpl)itemMgr.getItem(nodeId);
                boolean isAcItem = this.util.isAcItem(node);
                EntryFilterImpl filter = path == null ? new EntryFilterImpl(this.principalNames, id, this.session) : new EntryFilterImpl(this.principalNames, path, (PathResolver)this.session);
                if (isAcItem) {
                    AbstractCompiledPermissions.Result result = this.buildResult(node, isExistingNode, this.util.isAcItem(node), filter);
                    canRead = result.grants(1);
                } else {
                    for (AccessControlEntry accessControlEntry : this.entryCollector.collectEntries(node, filter)) {
                        ACLTemplate.Entry ace = (ACLTemplate.Entry)accessControlEntry;
                        int entryBits = ace.getPrivilegeBits();
                        if ((entryBits & 1) != 1) continue;
                        canRead = ace.isAllow();
                        break;
                    }
                }
                this.readCache.put(id, canRead);
            }
        }
        return canRead;
    }

    @Override
    public void acModified(AccessControlModifications modifications) {
        this.clearCache();
    }
}

