/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.assistant.refactor;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.assistant.info.RuleRefactorInfo;
import org.drools.ide.common.assistant.info.drl.DRLContentTypeEnum;
import org.drools.ide.common.assistant.info.drl.DRLRuleRefactorInfo;
import org.drools.ide.common.assistant.info.drl.RuleBasicContentInfo;
import org.drools.ide.common.assistant.option.AssistantOption;
import org.drools.ide.common.assistant.option.RenameAssistantOption;
import org.drools.ide.common.assistant.option.ReplaceAssistantOption;
import org.drools.ide.common.assistant.refactor.AbstractRuleRefactor;
import org.drools.ide.common.assistant.refactor.drl.FixImport;
import org.drools.ide.common.assistant.refactor.drl.VariableBinding;
import org.drools.ide.common.assistant.refactor.drl.VariableRename;

public class DRLRuleRefactor
extends AbstractRuleRefactor {
    public DRLRuleRefactor(RuleRefactorInfo refactorInfo) {
        this.ruleRefactorInfo = refactorInfo;
        this.options = new ArrayList();
    }

    @Override
    public List<AssistantOption> execute(int offset) {
        this.offset = offset;
        RuleBasicContentInfo contentInfo = ((DRLRuleRefactorInfo)this.ruleRefactorInfo).getContentAt(offset);
        if (contentInfo == null) {
            return this.options;
        }
        this.option = this.bindVariable(contentInfo);
        if (this.option != null) {
            this.options.add(this.option);
        }
        if ((this.option = this.fixImports(contentInfo)) != null) {
            this.options.add(this.option);
        }
        if ((this.option = this.renameVariable(contentInfo)) != null) {
            this.options.add(this.option);
        }
        return this.options;
    }

    @Override
    protected AssistantOption bindVariable(RuleBasicContentInfo contentInfo) {
        if (contentInfo == null) {
            return null;
        }
        if (!contentInfo.getType().equals((Object)DRLContentTypeEnum.RULE_LHS_LINE)) {
            return null;
        }
        String response = VariableBinding.execute(contentInfo, this.offset - contentInfo.getOffset());
        if (response.equals(contentInfo.getContent())) {
            return null;
        }
        return new ReplaceAssistantOption("assign to variable", response, contentInfo.getOffset(), contentInfo.getContentLength(), this.offset);
    }

    @Override
    protected AssistantOption fixImports(RuleBasicContentInfo contentInfo) {
        if (contentInfo == null) {
            return null;
        }
        if (!contentInfo.getType().equals((Object)DRLContentTypeEnum.RULE_LHS_LINE) && !contentInfo.getType().equals((Object)DRLContentTypeEnum.RULE_RHS_LINE)) {
            return null;
        }
        List<RuleBasicContentInfo> imports = ((DRLRuleRefactorInfo)this.ruleRefactorInfo).getImports();
        FixImport.execute(contentInfo, imports);
        return null;
    }

    @Override
    protected AssistantOption renameVariable(RuleBasicContentInfo contentInfo) {
        if (contentInfo == null) {
            return null;
        }
        if (!contentInfo.getType().equals((Object)DRLContentTypeEnum.RULE_LHS_LINE) && !contentInfo.getType().equals((Object)DRLContentTypeEnum.RULE_RHS_LINE)) {
            return null;
        }
        String variable = VariableRename.isPossible(contentInfo, this.offset - contentInfo.getOffset());
        if (variable != null) {
            return new RenameAssistantOption("rename variable", variable, contentInfo, contentInfo.getOffset());
        }
        return null;
    }
}

