/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.verifiers;

import java.util.Map;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

public class RuleFiredVerifier {
    private Map<String, Integer> firingCounts;

    public void setFireCounter(Map<String, Integer> firingCounts) {
        this.firingCounts = firingCounts;
    }

    public void verifyFiringCounts(VerifyRuleFired verifyRuleFired) {
        this.setActualResult(verifyRuleFired);
        if (verifyRuleFired.getExpectedFire() != null) {
            if (verifyRuleFired.getExpectedFire().booleanValue()) {
                this.verifyFiredAtLeastOnce(verifyRuleFired);
            } else {
                this.verifyFiredZeroTimes(verifyRuleFired);
            }
        }
        if (verifyRuleFired.getExpectedCount() != null) {
            this.verifyFiredXTimes(verifyRuleFired);
        }
    }

    private void verifyFiredXTimes(VerifyRuleFired verifyRuleFired) {
        if (verifyRuleFired.getActualResult().equals(verifyRuleFired.getExpectedCount())) {
            verifyRuleFired.setSuccessResult(true);
            verifyRuleFired.setExplanation("Rule [" + verifyRuleFired.getRuleName() + "] activated " + verifyRuleFired.getActualResult() + " times.");
        } else {
            verifyRuleFired.setSuccessResult(false);
            verifyRuleFired.setExplanation("Rule [" + verifyRuleFired.getRuleName() + "] activated " + verifyRuleFired.getActualResult() + " times. Expected " + verifyRuleFired.getExpectedCount() + " times.");
        }
    }

    private void verifyFiredZeroTimes(VerifyRuleFired verifyRuleFired) {
        if (verifyRuleFired.getActualResult() == 0) {
            verifyRuleFired.setSuccessResult(true);
            verifyRuleFired.setExplanation("Rule [" + verifyRuleFired.getRuleName() + "] was not activated.");
        } else {
            verifyRuleFired.setSuccessResult(false);
            verifyRuleFired.setExplanation("Rule [" + verifyRuleFired.getRuleName() + "] was activated " + verifyRuleFired.getActualResult() + " times, but expected none.");
        }
    }

    private void verifyFiredAtLeastOnce(VerifyRuleFired verifyRuleFired) {
        if (verifyRuleFired.getActualResult() > 0) {
            verifyRuleFired.setSuccessResult(true);
            verifyRuleFired.setExplanation("Rule [" + verifyRuleFired.getRuleName() + "] was actived " + verifyRuleFired.getActualResult() + " times.");
        } else {
            verifyRuleFired.setSuccessResult(false);
            verifyRuleFired.setExplanation("Rule [" + verifyRuleFired.getRuleName() + "] was not activated. Expected it to be activated.");
        }
    }

    private void setActualResult(VerifyRuleFired verifyRuleFired) {
        if (this.firingCounts.containsKey(verifyRuleFired.getRuleName())) {
            verifyRuleFired.setActualResult(this.firingCounts.get(verifyRuleFired.getRuleName()));
        } else {
            verifyRuleFired.setActualResult(0);
        }
    }
}

