/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;

public class ModuleIterator
implements Iterator<ModuleItem> {
    private final NodeIterator moduleNodeIterator;
    private final RulesRepository repository;
    private boolean searchArchived = false;
    private Node current = null;
    private Node next = null;

    public ModuleIterator() {
        this(null, null);
    }

    public ModuleIterator(RulesRepository repository, NodeIterator moduleNodes) {
        this.moduleNodeIterator = moduleNodes;
        this.repository = repository;
    }

    @Override
    public boolean hasNext() {
        if (this.moduleNodeIterator == null) {
            return false;
        }
        boolean hasnext = false;
        if (this.next == null) {
            while (this.moduleNodeIterator.hasNext()) {
                Node element = (Node)this.moduleNodeIterator.next();
                try {
                    if (!this.searchArchived && element.getProperty("drools:archive").getBoolean() || "globalArea".equals(element.getName())) continue;
                    hasnext = true;
                    this.next = element;
                    break;
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        } else {
            hasnext = true;
        }
        return hasnext;
    }

    @Override
    public ModuleItem next() {
        if (this.next == null) {
            this.hasNext();
        }
        this.current = this.next;
        this.next = null;
        if (this.current == null) {
            throw new NoSuchElementException("No more elements to return");
        }
        return new ModuleItem(this.repository, this.current);
    }

    public void setArchivedIterator(boolean search) {
        this.searchArchived = search;
    }

    public boolean isSetArchivedSearch() {
        return this.searchArchived;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("You can not remove items this way.");
    }
}

