/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.util;

import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.schema.MetaType;

public final class KObjectUtil {
    public static KObject toKObject(final Document document) {
        return new KObject(){

            public String getId() {
                return document.get("id");
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return document.get("type");
                    }
                };
            }

            public String getClusterId() {
                return document.get("cluster.id");
            }

            public String getSegmentId() {
                return document.get("segment.id");
            }

            public String getKey() {
                return document.get("key");
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof KObject)) {
                    return false;
                }
                KObject kobj = (KObject)obj;
                return this.getClusterId().equals(kobj.getClusterId()) && this.getId().equals(kobj.getId()) && this.getKey().equals(kobj.getKey()) && this.getType().getName().equals(kobj.getType().getName());
            }

            public int hashCode() {
                int result = this.getId().hashCode();
                result = 31 * result + this.getClusterId().hashCode();
                result = 31 * result + this.getKey().hashCode();
                result = 31 * result + this.getType().getName().hashCode();
                return result;
            }

            public Iterable<KProperty<?>> getProperties() {
                ArrayList kProperties = new ArrayList();
                for (final IndexableField indexableField : document) {
                    if (!this.isExtension(indexableField.name())) continue;
                    kProperties.add(new KProperty<Object>(){

                        public String getName() {
                            return indexableField.name();
                        }

                        public Object getValue() {
                            return indexableField.stringValue();
                        }

                        public boolean isSearchable() {
                            return true;
                        }
                    });
                }
                return kProperties;
            }

            public boolean fullText() {
                return true;
            }

            private boolean isExtension(String name) {
                return !name.equals("id") && !name.equals("type") && !name.equals("cluster.id") && !name.equals("segment.id") && !name.equals("key");
            }
        };
    }
}

