/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.command.ConversationContext;
import org.drools.core.command.RequestContextImpl;
import org.kie.internal.command.Context;

public class ConversationContextManager {
    private Map<Long, Context> conversationContexts = new HashMap<Long, Context>();
    private long counter;

    public void startConversation(RequestContextImpl requestContext) {
        long conversationId = this.counter++;
        ConversationContext ctx = new ConversationContext(conversationId, null);
        this.conversationContexts.put(conversationId, ctx);
        requestContext.setConversationContext(ctx);
    }

    public void joinConversation(RequestContextImpl requestContext, long conversationId) {
        ConversationContext ctx = (ConversationContext)this.conversationContexts.get(conversationId);
        if (ctx == null) {
            throw new RuntimeException("Conversation cannot be found");
        }
        requestContext.setConversationContext(ctx);
    }

    public void leaveConversation(RequestContextImpl requestContext, long conversationId) {
        throw new UnsupportedOperationException("Need to implement");
    }

    public void endConversation(RequestContextImpl requestContext, long conversationId) {
        this.conversationContexts.remove(conversationId);
        requestContext.setConversationContext(null);
    }
}

