/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.drools.core.base.ClassTypeResolver;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationTools;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.Parameter;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaTypeInfoImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ParameterImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.TypeImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.FilterHolder;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverListener;
import org.kie.workbench.common.services.datamodeller.driver.TypeInfoResult;
import org.kie.workbench.common.services.datamodeller.driver.impl.DefaultJavaRoasterModelAnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.UpdateInfo;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.CommonAnnotations;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSource;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverResult;
import org.kie.workbench.common.services.datamodeller.driver.model.ModelDriverResult;
import org.kie.workbench.common.services.datamodeller.util.DataModelUtils;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.data.Pair;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class JavaRoasterModelDriver
implements ModelDriver {
    private static final Logger logger = LoggerFactory.getLogger(JavaRoasterModelDriver.class);
    private IOService ioService;
    private Path javaRootPath;
    private ClassLoader classLoader;
    private List<AnnotationDefinition> configuredAnnotations = new ArrayList<AnnotationDefinition>();
    private Map<String, AnnotationDefinition> configuredAnnotationsIndex = new HashMap<String, AnnotationDefinition>();
    private Map<String, AnnotationDriver> annotationDrivers = new HashMap<String, AnnotationDriver>();
    private FilterHolder filterHolder;
    private static final String DATA_OBJECT_LOAD_ERROR = "It was not possible to create or load DataObject: \"{0}\" .";
    private static final String ANNOTATION_LOAD_ERROR = "It was not possible to create or load a DataObject or Field annotation for annotation class name: \"{0}\" .";
    private static final String DATA_OBJECT_FIELD_LOAD_ERROR = "It was not possible to create or load field: \"{0}\" for DataObject: \"{1}\" .";
    private static final String MODEL_LOAD_GENERIC_ERROR = "Unexpected error was produced when a DataModel was being loaded from the following path: \"{0}\" .";
    private static final String GENERIC_ERROR = "Unexpected error was produced.";

    public JavaRoasterModelDriver() {
        this.configuredAnnotations.addAll(CommonAnnotations.getCommonAnnotations());
        for (AnnotationDefinition annotationDefinition : this.configuredAnnotations) {
            this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultJavaRoasterModelAnnotationDriver());
            this.configuredAnnotationsIndex.put(annotationDefinition.getClassName(), annotationDefinition);
        }
    }

    public JavaRoasterModelDriver(FilterHolder filterHolder) {
        this();
        this.filterHolder = filterHolder;
    }

    public JavaRoasterModelDriver(IOService ioService, Path javaRootPath, ClassLoader classLoader, FilterHolder filterHolder) {
        this();
        this.ioService = ioService;
        this.javaRootPath = javaRootPath;
        this.classLoader = classLoader;
        this.filterHolder = filterHolder;
    }

    @Override
    public List<AnnotationDefinition> getConfiguredAnnotations() {
        return this.configuredAnnotations;
    }

    @Override
    public AnnotationDefinition getConfiguredAnnotation(String annotationClassName) {
        return this.configuredAnnotationsIndex.get(annotationClassName);
    }

    @Override
    public AnnotationDriver getAnnotationDriver(String annotationClassName) {
        return this.annotationDrivers.get(annotationClassName);
    }

    @Override
    public void generateModel(DataModel dataModel, ModelDriverListener generationListener) throws Exception {
    }

    @Override
    public ModelDriverResult loadModel() throws ModelDriverException {
        ModelDriverResult result = new ModelDriverResult();
        DataModel dataModel = this.createModel();
        result.setDataModel(dataModel);
        ArrayList<Path> rootPaths = new ArrayList<Path>();
        rootPaths.add(this.javaRootPath);
        Collection<FileUtils.ScanResult> scanResults = FileUtils.getInstance().scan(this.ioService, rootPaths, ".java", true);
        if (scanResults != null) {
            for (FileUtils.ScanResult scanResult : scanResults) {
                logger.debug("Starting file loading into model, file: " + scanResult.getFile());
                String fileContent = this.ioService.readAllString(scanResult.getFile());
                if (fileContent == null || "".equals(fileContent)) {
                    logger.debug("file: " + scanResult.getFile() + " is empty.");
                    continue;
                }
                try {
                    boolean vetoed;
                    JavaType javaType = Roaster.parse((String)fileContent);
                    boolean isClass = javaType.isClass();
                    boolean bl = vetoed = isClass ? this.isVetoed(javaType) : false;
                    if (isClass && !vetoed) {
                        if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                            this.addSyntaxErrors(result, scanResult.getFile(), javaType.getSyntaxErrors());
                            continue;
                        }
                        try {
                            Pair<DataObject, List<ObjectProperty>> pair = this.parseDataObject((JavaClassSource)javaType);
                            if (pair.getK1() == null) continue;
                            dataModel.addDataObject((DataObject)pair.getK1());
                            result.setClassPath(((DataObject)pair.getK1()).getClassName(), Paths.convert((Path)scanResult.getFile()));
                            result.setUnmanagedProperties(((DataObject)pair.getK1()).getClassName(), (List)pair.getK2());
                        }
                        catch (ModelDriverException e) {
                            logger.error("An error was produced when file: " + scanResult.getFile() + " was being loaded into a DataObject.", (Throwable)e);
                            this.addModelDriverError(result, scanResult.getFile(), e);
                        }
                        continue;
                    }
                    if (vetoed) {
                        logger.debug("The class, {}, in the file, {}, was vetoed and will be skipped.", (Object)javaType.getQualifiedName(), (Object)scanResult.getFile());
                        continue;
                    }
                    logger.debug("No Class definition was found for file: " + scanResult.getFile() + ", it will be skipped.");
                }
                catch (Exception e) {
                    logger.error(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), (Throwable)e);
                    throw new ModelDriverException(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), e);
                }
            }
        }
        return result;
    }

    private boolean isVetoed(JavaType<?> javaType) {
        return this.filterHolder.getSourceFilters().stream().anyMatch(filter -> filter.veto(javaType));
    }

    private boolean isAccepted(JavaType<?> nestedClass) {
        return this.filterHolder.getNestedClassFilters().stream().anyMatch(filter -> filter.accept(nestedClass));
    }

    private boolean isAccepted(org.jboss.forge.roaster.model.Method<?, ?> method) {
        return this.filterHolder.getMethodFilters().stream().anyMatch(filter -> filter.accept(method));
    }

    public ModelDriverResult loadDataObject(String source, Path path) throws ModelDriverException {
        ModelDriverResult result = new ModelDriverResult();
        DataModel dataModel = this.createModel();
        result.setDataModel(dataModel);
        if (source == null || "".equals(source)) {
            logger.debug("source: " + source + " is empty.");
            return result;
        }
        try {
            JavaType javaType = Roaster.parse((String)source);
            if (javaType.isClass()) {
                if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                    this.addSyntaxErrors(result, path, javaType.getSyntaxErrors());
                } else {
                    try {
                        Pair<DataObject, List<ObjectProperty>> pair = this.parseDataObject((JavaClassSource)javaType);
                        dataModel.addDataObject((DataObject)pair.getK1());
                        result.setClassPath(((DataObject)pair.getK1()).getClassName(), Paths.convert((Path)path));
                        result.setUnmanagedProperties(((DataObject)pair.getK1()).getClassName(), (List)pair.getK2());
                    }
                    catch (ModelDriverException e) {
                        logger.error("An error was produced when source: " + source + " was being loaded into a DataObject.", (Throwable)e);
                        this.addModelDriverError(result, path, e);
                    }
                }
            } else {
                logger.debug("No Class definition was found for source: " + source + ", it will be skipped.");
            }
        }
        catch (Exception e) {
            logger.error(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), e);
        }
        return result;
    }

    public TypeInfoResult loadJavaTypeInfo(String source) throws ModelDriverException {
        TypeInfoResult result = new TypeInfoResult();
        if (source == null || "".equals(source)) {
            logger.debug("source: " + source + " is empty.");
            return result;
        }
        try {
            JavaType javaType = Roaster.parse((String)source);
            if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                this.addSyntaxErrors(result, null, javaType.getSyntaxErrors());
            } else {
                JavaTypeInfoImpl typeInfo = new JavaTypeInfoImpl();
                result.setTypeInfo(typeInfo);
                typeInfo.setName(javaType.getName());
                typeInfo.setPackageName(javaType.getPackage());
                typeInfo.setAnnotation(javaType.isAnnotation());
                typeInfo.setClass(javaType.isClass());
                typeInfo.setEnum(javaType.isEnum());
                typeInfo.setInterface(javaType.isInterface());
                typeInfo.setPackagePrivate(javaType.isPackagePrivate());
                typeInfo.setPrivate(javaType.isPrivate());
                typeInfo.setProtected(javaType.isProtected());
                typeInfo.setInterface(javaType.isInterface());
            }
        }
        catch (Exception e) {
            logger.error(this.errorMessage(GENERIC_ERROR, e));
            throw new ModelDriverException(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, new Object[0]), e);
        }
        return result;
    }

    public AnnotationSourceResponse resolveSourceRequest(AnnotationSourceRequest sourceRequest) {
        AnnotationSourceResponse sourceResponse = new AnnotationSourceResponse();
        for (org.kie.workbench.common.services.datamodeller.core.Annotation annotation : sourceRequest.getAnnotations()) {
            sourceResponse.withAnnotationSource(annotation.getClassName(), this.resolveAnnotationSource(annotation));
        }
        return sourceResponse;
    }

    public AnnotationSource resolveAnnotationSource(org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        AnnotationSource annotationSource = new AnnotationSource();
        GenerationTools generationTools = new GenerationTools();
        StringBuilder annotationCode = new StringBuilder();
        annotationCode.append("@");
        annotationCode.append(annotation.getClassName());
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        if (annotationDefinition != null) {
            if (!annotationDefinition.isMarker()) {
                annotationCode.append(generationTools.resolveAnnotationType(annotation));
            }
            if (annotationDefinition.getValuePairs() != null) {
                for (AnnotationValuePairDefinition valuePairDefinition : annotationDefinition.getValuePairs()) {
                    Object value = annotation.getValue(valuePairDefinition.getName());
                    String valuePairCode = value != null ? generationTools.resolveMemberTypeExpression(valuePairDefinition, value) : null;
                    annotationSource.withValuePairSource(valuePairDefinition.getName(), valuePairCode);
                }
            }
        }
        annotationSource.withSource(annotationCode.toString());
        return annotationSource;
    }

    private void addModelDriverError(ModelDriverResult result, Path file, ModelDriverException e) {
        StringBuilder message = new StringBuilder();
        message.append(e.getMessage());
        Throwable cause = e.getCause();
        while (cause != null) {
            message.append(" : ");
            message.append(cause.getMessage());
            if (cause instanceof ModelDriverException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        DriverError error = new DriverError(message.toString(), Paths.convert((Path)file));
        result.addError(error);
    }

    private void addSyntaxErrors(DriverResult result, Path file, List<SyntaxError> syntaxErrors) {
        for (SyntaxError syntaxError : syntaxErrors) {
            DriverError error = new DriverError(syntaxError.getDescription(), Paths.convert((Path)file));
            error.setLine(syntaxError.getLine());
            error.setColumn(syntaxError.getColumn());
            result.addError(error);
        }
    }

    @Override
    public DataModel createModel() {
        return ModelFactoryImpl.getInstance().newModel();
    }

    private Pair<DataObject, List<ObjectProperty>> parseDataObject(JavaClassSource javaClassSource) throws ModelDriverException {
        String className = javaClassSource.getName();
        String packageName = javaClassSource.getPackage();
        String qualifiedName = NamingUtils.createQualifiedName(packageName, className);
        if (logger.isDebugEnabled()) {
            logger.debug("Building DataObject for, packageName: " + packageName + ", className: " + className);
        }
        ClassTypeResolver classTypeResolver = DriverUtils.createClassTypeResolver((JavaSource)javaClassSource, this.classLoader);
        org.kie.workbench.common.services.datamodeller.core.Visibility visibility = DriverUtils.buildVisibility(javaClassSource.getVisibility());
        DataObjectImpl dataObject = new DataObjectImpl(packageName, className, visibility, javaClassSource.isAbstract(), javaClassSource.isFinal());
        ArrayList<ObjectPropertyImpl> unmanagedProperties = new ArrayList<ObjectPropertyImpl>();
        try {
            List fields;
            List nestedTypes;
            List classMethods;
            List annotations;
            if (javaClassSource.getSuperType() != null) {
                String superClass = this.resolveTypeName(classTypeResolver, javaClassSource.getSuperType());
                dataObject.setSuperClassName(superClass);
            }
            if ((annotations = javaClassSource.getAnnotations()) != null) {
                for (org.jboss.forge.roaster.model.source.AnnotationSource annotation : annotations) {
                    this.addJavaClassAnnotation(dataObject, annotation, classTypeResolver);
                }
            }
            if ((classMethods = javaClassSource.getMethods()) != null) {
                for (MethodSource classMethod : classMethods) {
                    if (!this.isAccepted((org.jboss.forge.roaster.model.Method<?, ?>)classMethod)) continue;
                    this.addMethod(dataObject, (org.jboss.forge.roaster.model.Method)classMethod, classTypeResolver);
                }
            }
            if ((nestedTypes = javaClassSource.getNestedTypes()) != null) {
                for (JavaSource nestedType : nestedTypes) {
                    List nestedClassMethods;
                    List nestedClassAnnotations;
                    if (!this.isAccepted((JavaType<?>)nestedType) || !(nestedType instanceof JavaClassSource)) continue;
                    JavaClassImpl nestedJavaClass = new JavaClassImpl("", nestedType.getName(), DriverUtils.buildVisibility(nestedType.getVisibility()));
                    dataObject.addNestedClass(nestedJavaClass);
                    if (javaClassSource.getInterfaces() != null) {
                        for (Object interfaceDefinition : ((JavaClassSource)nestedType).getInterfaces()) {
                            nestedJavaClass.addInterface((String)interfaceDefinition);
                        }
                    }
                    if ((nestedClassAnnotations = nestedType.getAnnotations()) != null) {
                        Object interfaceDefinition;
                        interfaceDefinition = nestedClassAnnotations.iterator();
                        while (interfaceDefinition.hasNext()) {
                            org.jboss.forge.roaster.model.source.AnnotationSource annotation = (org.jboss.forge.roaster.model.source.AnnotationSource)interfaceDefinition.next();
                            this.addJavaClassAnnotation(nestedJavaClass, annotation, classTypeResolver);
                        }
                    }
                    if ((nestedClassMethods = ((JavaClassSource)nestedType).getMethods()) == null) continue;
                    for (org.jboss.forge.roaster.model.Method nestedClassMethod : nestedClassMethods) {
                        if (!this.isAccepted(nestedClassMethod)) continue;
                        this.addMethod(nestedJavaClass, nestedClassMethod, classTypeResolver);
                    }
                }
            }
            if ((fields = javaClassSource.getFields()) != null) {
                for (FieldSource field : fields) {
                    if (DriverUtils.isManagedType(field.getType(), classTypeResolver)) {
                        this.addProperty(dataObject, (FieldSource<JavaClassSource>)field, classTypeResolver);
                        continue;
                    }
                    logger.debug("field: " + field + "with fieldName: " + field.getName() + " won't be loaded by the diver because type: " + field.getType().getName() + " isn't a managed type.");
                    unmanagedProperties.add(new ObjectPropertyImpl(field.getName(), field.getType().toString(), false, DriverUtils.buildVisibility(field.getVisibility()), field.isStatic(), field.isFinal()));
                }
            }
            return new Pair((Object)dataObject, unmanagedProperties);
        }
        catch (ClassNotFoundException e) {
            logger.error(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), e);
        }
        catch (ModelDriverException e) {
            logger.error(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), e);
        }
    }

    private ObjectProperty addProperty(DataObject dataObject, FieldSource<JavaClassSource> field, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        ObjectProperty property = this.parseProperty(field, classTypeResolver);
        dataObject.addProperty(property);
        return property;
    }

    private List<org.kie.workbench.common.services.datamodeller.core.Type> resolveTypeArguments(List<Type> typeArguments) {
        ArrayList<org.kie.workbench.common.services.datamodeller.core.Type> result = new ArrayList<org.kie.workbench.common.services.datamodeller.core.Type>();
        if (typeArguments != null) {
            this.resolveTypeArguments(typeArguments, result);
        }
        return result;
    }

    private void resolveTypeArguments(List<Type> typeArguments, List<org.kie.workbench.common.services.datamodeller.core.Type> resultTypeArguments) {
        if (typeArguments != null) {
            for (Type typeArgument : typeArguments) {
                TypeImpl resultType = new TypeImpl(typeArgument.getQualifiedName(), new ArrayList<org.kie.workbench.common.services.datamodeller.core.Type>());
                resultTypeArguments.add(resultType);
                this.resolveTypeArguments(typeArgument.getTypeArguments(), resultType.getTypeArguments());
            }
        }
    }

    private void addMethod(org.kie.workbench.common.services.datamodeller.core.JavaClass javaClass, org.jboss.forge.roaster.model.Method method, ClassTypeResolver classTypeResolver) throws ClassNotFoundException, ModelDriverException {
        List parameters = method.getParameters();
        ArrayList<Parameter> modelParameters = new ArrayList<Parameter>();
        if (parameters != null) {
            for (org.jboss.forge.roaster.model.Parameter parameter : parameters) {
                modelParameters.add(new ParameterImpl(new TypeImpl(this.resolveTypeName(classTypeResolver, parameter.getType().getName()), this.resolveTypeArguments(parameter.getType().getTypeArguments())), parameter.getName()));
            }
        }
        TypeImpl returnType = null;
        if (method.getReturnType() != null) {
            returnType = new TypeImpl(this.resolveTypeName(classTypeResolver, method.getReturnType().getName()), this.resolveTypeArguments(method.getReturnType().getTypeArguments()));
        }
        org.kie.workbench.common.services.datamodeller.core.Visibility visibility = org.kie.workbench.common.services.datamodeller.core.Visibility.PACKAGE_PRIVATE;
        if (method.getVisibility() != null) {
            visibility = DriverUtils.buildVisibility(method.getVisibility());
        }
        MethodImpl dataObjectMethod = new MethodImpl(method.getName(), modelParameters, method.getBody(), returnType, visibility);
        List annotations = method.getAnnotations();
        if (annotations != null) {
            for (org.jboss.forge.roaster.model.source.AnnotationSource annotation : annotations) {
                dataObjectMethod.addAnnotation(this.createAnnotation(annotation, classTypeResolver));
            }
        }
        javaClass.addMethod(dataObjectMethod);
    }

    public ObjectProperty parseProperty(FieldSource<JavaClassSource> field, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        ObjectPropertyImpl property;
        boolean multiple = false;
        String bag = null;
        org.kie.workbench.common.services.datamodeller.core.Visibility visibility = DriverUtils.buildVisibility(field.getVisibility());
        try {
            String className;
            Type type = field.getType();
            if (type.isPrimitive()) {
                className = type.getName();
            } else if (DriverUtils.isSimpleClass(type)) {
                className = this.resolveTypeName(classTypeResolver, type.getName());
            } else {
                multiple = true;
                Type elementsType = (Type)type.getTypeArguments().get(0);
                className = this.resolveTypeName(classTypeResolver, elementsType.getName());
                bag = this.resolveTypeName(classTypeResolver, type.getName());
            }
            property = new ObjectPropertyImpl(field.getName(), className, multiple, bag, visibility, field.isStatic(), field.isFinal());
            List annotations = field.getAnnotations();
            if (annotations != null) {
                for (org.jboss.forge.roaster.model.source.AnnotationSource annotation : annotations) {
                    this.addPropertyAnnotation(property, annotation, classTypeResolver);
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(this.errorMessage(DATA_OBJECT_FIELD_LOAD_ERROR, field.getName(), ((JavaClassSource)field.getOrigin()).getName()), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(DATA_OBJECT_FIELD_LOAD_ERROR, field.getName(), ((JavaClassSource)field.getOrigin()).getName()), e);
        }
        return property;
    }

    public List<ObjectProperty> parseManagedTypesProperties(JavaClassSource javaClassSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        List fields = javaClassSource.getFields();
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        for (FieldSource field : fields) {
            if (DriverUtils.isManagedType(field.getType(), classTypeResolver)) {
                ObjectProperty property = this.parseProperty((FieldSource<JavaClassSource>)field, classTypeResolver);
                properties.add(property);
                continue;
            }
            logger.debug("field: " + field + "with fieldName: " + field.getName() + " won't be loaded by the diver because type: " + field.getType().getName() + " isn't a managed type.");
        }
        return properties;
    }

    private void addJavaClassAnnotation(org.kie.workbench.common.services.datamodeller.core.JavaClass javaClass, org.jboss.forge.roaster.model.source.AnnotationSource annotationSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        org.kie.workbench.common.services.datamodeller.core.Annotation annotation = this.createAnnotation(annotationSource, classTypeResolver);
        if (annotation != null) {
            javaClass.addAnnotation(annotation);
        }
    }

    private void addPropertyAnnotation(ObjectProperty property, org.jboss.forge.roaster.model.source.AnnotationSource annotationSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        org.kie.workbench.common.services.datamodeller.core.Annotation annotation = this.createAnnotation(annotationSource, classTypeResolver);
        if (annotation != null) {
            property.addAnnotation(annotation);
        }
    }

    private org.kie.workbench.common.services.datamodeller.core.Annotation createAnnotation(org.jboss.forge.roaster.model.source.AnnotationSource annotationToken, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        org.kie.workbench.common.services.datamodeller.core.Annotation annotation = null;
        AnnotationDefinition annotationDefinition = this.buildAnnotationDefinition(annotationToken, classTypeResolver);
        if (annotationDefinition != null) {
            DefaultJavaRoasterModelAnnotationDriver annotationDriver = new DefaultJavaRoasterModelAnnotationDriver();
            annotation = annotationDriver.buildAnnotation(annotationDefinition, annotationToken);
        } else {
            logger.warn("Annotation: " + annotationToken.getName() + " is not configured for this ModelDriver driver.");
        }
        return annotation;
    }

    public AnnotationDefinition buildAnnotationDefinition(org.jboss.forge.roaster.model.source.AnnotationSource annotationSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        return this.buildAnnotationDefinition(annotationSource.getQualifiedName(), classTypeResolver);
    }

    public AnnotationDefinition buildAnnotationDefinition(String annotationClassName, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        try {
            String resolvedClassName = this.resolveTypeName(classTypeResolver, annotationClassName);
            Class annotationClass = classTypeResolver.resolveType(resolvedClassName);
            return DriverUtils.buildAnnotationDefinition(annotationClass);
        }
        catch (ClassNotFoundException e) {
            logger.error(this.errorMessage(ANNOTATION_LOAD_ERROR, annotationClassName), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(ANNOTATION_LOAD_ERROR, annotationClassName), e);
        }
    }

    private String resolveTypeName(ClassTypeResolver classTypeResolver, String name) throws ClassNotFoundException {
        try {
            if (name == null) {
                return null;
            }
            if (NamingUtils.isQualifiedName(name)) {
                return name;
            }
            if ("void".equals(name)) {
                return name;
            }
            return classTypeResolver.getFullTypeName(name);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class could not be resolved for name: " + name, (Throwable)e);
            throw e;
        }
    }

    public void updateImports(JavaClassSource javaClassSource, Map<String, String> renamedClasses, List<String> deletedClasses) {
        String currentPackage;
        List imports = javaClassSource.getImports();
        String string = currentPackage = javaClassSource.isDefaultPackage() ? null : javaClassSource.getPackage();
        if (imports != null) {
            for (Import currentImport : imports) {
                if (currentImport.isWildcard() || currentImport.isStatic()) continue;
                String newClassName = renamedClasses.get(currentImport.getQualifiedName());
                if (newClassName != null) {
                    javaClassSource.removeImport(currentImport);
                    if (StringUtils.equals((CharSequence)currentPackage, (CharSequence)NamingUtils.extractPackageName(newClassName))) continue;
                    javaClassSource.addImport(newClassName);
                    continue;
                }
                if (!deletedClasses.contains(currentImport.getQualifiedName())) continue;
                javaClassSource.removeImport(currentImport);
            }
        }
    }

    public boolean updatePackage(JavaClassSource javaClassSource, String packageName) {
        String oldPackageName = javaClassSource.getPackage();
        if (packageName == null) {
            javaClassSource.setDefaultPackage();
        } else {
            javaClassSource.setPackage(packageName);
        }
        return StringUtils.equals((CharSequence)oldPackageName, (CharSequence)packageName);
    }

    public void updateSource(JavaClassSource javaClassSource, DataObject dataObject, UpdateInfo updateInfo, ClassTypeResolver classTypeResolver) throws Exception {
        if (javaClassSource == null || !javaClassSource.isClass()) {
            logger.warn("A null javaClassSource or javaClassSouce is not a Class, no processing will be done. javaClassSource: " + javaClassSource + " className: " + (javaClassSource != null ? javaClassSource.getName() : null));
            return;
        }
        HashMap<String, FieldSource> currentClassFields = new HashMap<String, FieldSource>();
        List classFields = javaClassSource.getFields();
        HashMap<String, String> preservedFields = new HashMap<String, String>();
        this.updatePackage(javaClassSource, dataObject.getPackageName());
        this.updateImports(javaClassSource, updateInfo.getRenamedClasses(), updateInfo.getDeletedClasses());
        this.updateAnnotations((AnnotationTargetSource)javaClassSource, dataObject.getAnnotations(), classTypeResolver);
        this.updateMethods(javaClassSource, dataObject.getMethods(), classTypeResolver);
        this.updateClassName(javaClassSource, dataObject.getName());
        this.updateSuperClassName(javaClassSource, dataObject.getSuperClassName(), classTypeResolver);
        if (classFields != null) {
            for (FieldSource field : classFields) {
                currentClassFields.put(field.getName(), field);
            }
        }
        List<ObjectProperty> currentManagedProperties = this.parseManagedTypesProperties(javaClassSource, classTypeResolver);
        currentManagedProperties = DataModelUtils.filterAssignableFields(currentManagedProperties);
        List<MethodSource<JavaClassSource>> allFieldsConstructorCandidates = this.findAllFieldsConstructorCandidates(javaClassSource, currentManagedProperties, classTypeResolver);
        List<MethodSource<JavaClassSource>> keyFieldsConstructorCandidates = this.findKeyFieldsConstructorCandidates(javaClassSource, currentManagedProperties, classTypeResolver);
        List<MethodSource<JavaClassSource>> positionFieldsConstructorCandidates = this.findPositionFieldsConstructorCandidates(javaClassSource, currentManagedProperties, classTypeResolver);
        for (ObjectProperty objectProperty : dataObject.getProperties()) {
            if (objectProperty.isFinal() || objectProperty.isStatic()) {
                preservedFields.put(objectProperty.getName(), objectProperty.getName());
                continue;
            }
            if (currentClassFields.containsKey(objectProperty.getName())) {
                this.updateField(javaClassSource, objectProperty.getName(), objectProperty, classTypeResolver);
            } else {
                this.createField(javaClassSource, objectProperty, classTypeResolver);
            }
            preservedFields.put(objectProperty.getName(), objectProperty.getName());
        }
        this.updateConstructors(javaClassSource, dataObject, allFieldsConstructorCandidates, keyFieldsConstructorCandidates, positionFieldsConstructorCandidates, classTypeResolver);
        ArrayList<String> removableFields = new ArrayList<String>();
        for (FieldSource fieldSource : currentClassFields.values()) {
            if (preservedFields.containsKey(fieldSource.getName()) || !this.isManagedField((FieldSource<JavaClassSource>)fieldSource, classTypeResolver)) continue;
            removableFields.add(fieldSource.getName());
        }
        for (String string : removableFields) {
            this.removeField(javaClassSource, string, classTypeResolver);
        }
        List list = javaClassSource.getNestedTypes();
        if (list != null) {
            for (JavaSource nestedJavaSource : list) {
                if (!this.isAccepted((JavaType<?>)nestedJavaSource)) continue;
                javaClassSource.removeNestedType(nestedJavaSource);
            }
        }
        GenerationEngine generationEngine = GenerationEngine.getInstance();
        GenerationContext context = new GenerationContext(null);
        for (org.kie.workbench.common.services.datamodeller.core.JavaClass nestedJavaClass : dataObject.getNestedClasses()) {
            javaClassSource.addNestedType(generationEngine.generateNestedClassString(context, nestedJavaClass, ""));
        }
    }

    public boolean updateClassName(JavaClassSource javaClassSource, String name) throws Exception {
        String oldName = javaClassSource.getName();
        javaClassSource.setName(name);
        return StringUtils.equals((CharSequence)oldName, (CharSequence)name);
    }

    public boolean updateSuperClassName(JavaClassSource javaClassSource, String superClassName, ClassTypeResolver classTypeResolver) throws Exception {
        String oldSuperClassName;
        String string = oldSuperClassName = javaClassSource.getSuperType() != null ? this.resolveTypeName(classTypeResolver, javaClassSource.getSuperType()) : null;
        if (!StringUtils.equals((CharSequence)oldSuperClassName, (CharSequence)superClassName)) {
            javaClassSource.setSuperType(superClassName);
            return true;
        }
        return false;
    }

    public void updateAnnotations(AnnotationTargetSource annotationTargetSource, List<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations, ClassTypeResolver classTypeResolver) throws Exception {
        List currentAnnotations = annotationTargetSource.getAnnotations();
        if (currentAnnotations != null) {
            for (org.jboss.forge.roaster.model.source.AnnotationSource currentAnnotation : currentAnnotations) {
                annotationTargetSource.removeAnnotation((Annotation)currentAnnotation);
            }
        }
        if (annotations != null) {
            for (org.kie.workbench.common.services.datamodeller.core.Annotation annotation : annotations) {
                this.addAnnotation(annotationTargetSource, annotation);
            }
        }
    }

    public org.jboss.forge.roaster.model.source.AnnotationSource<?> addAnnotation(AnnotationTargetSource annotationTargetSource, org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        org.jboss.forge.roaster.model.source.AnnotationSource newAnnotationSource = annotationTargetSource.addAnnotation();
        newAnnotationSource.setName(annotation.getClassName());
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        if (!annotationDefinition.isMarker()) {
            for (AnnotationValuePairDefinition memberDefinition : annotationDefinition.getValuePairs()) {
                Object value = annotation.getValue(memberDefinition.getName());
                if (value == null) continue;
                this.addMemberValue(newAnnotationSource, memberDefinition, value);
            }
        }
        return newAnnotationSource;
    }

    public void addMemberValue(org.jboss.forge.roaster.model.source.AnnotationSource<?> annotationSource, AnnotationValuePairDefinition valuePairDefinition, Object value) {
        String encodedValue;
        if (value == null) {
            return;
        }
        if (valuePairDefinition.isEnum()) {
            String encodedValue2 = valuePairDefinition.isArray() ? DriverUtils.encodeEnumArrayValue(valuePairDefinition, value) : DriverUtils.encodeEnumValue(valuePairDefinition, value);
            if (encodedValue2 != null) {
                annotationSource.setLiteralValue(valuePairDefinition.getName(), encodedValue2);
            }
        } else if (valuePairDefinition.isString()) {
            String encodedValue3 = valuePairDefinition.isArray() ? DriverUtils.encodeStringArrayValue(value, true) : DriverUtils.encodeStringValue(value, true);
            if (encodedValue3 != null) {
                annotationSource.setLiteralValue(valuePairDefinition.getName(), encodedValue3);
            }
        } else if (valuePairDefinition.isPrimitiveType()) {
            String encodedValue4 = valuePairDefinition.isArray() ? DriverUtils.encodePrimitiveArrayValue(valuePairDefinition, value) : DriverUtils.encodePrimitiveValue(valuePairDefinition, value);
            if (encodedValue4 != null) {
                annotationSource.setLiteralValue(valuePairDefinition.getName(), encodedValue4);
            }
        } else if (valuePairDefinition.isAnnotation()) {
            if (valuePairDefinition.isArray()) {
                ArrayList<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations = new ArrayList<org.kie.workbench.common.services.datamodeller.core.Annotation>();
                if (value instanceof List) {
                    for (Object item : (List)value) {
                        if (!(item instanceof org.kie.workbench.common.services.datamodeller.core.Annotation)) continue;
                        annotations.add((org.kie.workbench.common.services.datamodeller.core.Annotation)item);
                    }
                } else if (value instanceof org.kie.workbench.common.services.datamodeller.core.Annotation) {
                    annotations.add((org.kie.workbench.common.services.datamodeller.core.Annotation)value);
                }
                this.addAnnotationArrayMemberValue(annotationSource, valuePairDefinition, annotations);
            } else if (value instanceof org.kie.workbench.common.services.datamodeller.core.Annotation) {
                this.addAnnotationMemberValue(annotationSource, valuePairDefinition, (org.kie.workbench.common.services.datamodeller.core.Annotation)value);
            }
        } else if (valuePairDefinition.isClass() && (encodedValue = valuePairDefinition.isArray() ? DriverUtils.encodeClassArrayValue(value) : DriverUtils.encodeClassValue(value.toString())) != null) {
            annotationSource.setLiteralValue(valuePairDefinition.getName(), encodedValue);
        }
    }

    private void addAnnotationMemberValue(org.jboss.forge.roaster.model.source.AnnotationSource annotationSource, AnnotationValuePairDefinition valuePairDefinition, org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        org.jboss.forge.roaster.model.source.AnnotationSource targetAnnotation = annotationSource.addAnnotationValue(valuePairDefinition.getName());
        targetAnnotation.setName(annotation.getClassName());
        if (!annotation.getAnnotationDefinition().isMarker()) {
            for (AnnotationValuePairDefinition memberDefinition : annotation.getAnnotationDefinition().getValuePairs()) {
                Object value = annotation.getValue(memberDefinition.getName());
                if (value == null) continue;
                this.addMemberValue(targetAnnotation, memberDefinition, value);
            }
        }
    }

    private void addAnnotationArrayMemberValue(org.jboss.forge.roaster.model.source.AnnotationSource annotationSource, AnnotationValuePairDefinition valuePairDefinition, List<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations) {
        if (annotations != null) {
            for (org.kie.workbench.common.services.datamodeller.core.Annotation annotation : annotations) {
                this.addAnnotationMemberValue(annotationSource, valuePairDefinition, annotation);
            }
        }
    }

    public void updateMethods(JavaClassSource javaClassSource, List<Method> methods, ClassTypeResolver classTypeResolver) throws Exception {
        List currentMethods = javaClassSource.getMethods();
        if (currentMethods != null) {
            for (MethodSource currentMethod : currentMethods) {
                if (!this.isAccepted((org.jboss.forge.roaster.model.Method<?, ?>)currentMethod)) continue;
                javaClassSource.removeMethod((org.jboss.forge.roaster.model.Method)currentMethod);
            }
        }
        if (methods != null) {
            for (Method method : methods) {
                this.addMethod(javaClassSource, method, classTypeResolver);
            }
        }
    }

    private void addMethod(JavaClassSource javaClassSource, Method method, ClassTypeResolver classTypeResolver) throws ClassNotFoundException {
        MethodSource methodSource = javaClassSource.addMethod();
        methodSource.setName(method.getName());
        methodSource.setReturnType(this.buildMethodReturnTypeString(method.getReturnType(), classTypeResolver));
        methodSource.setParameters(this.buildMethodParameterString(method.getParameters(), classTypeResolver));
        methodSource.setBody(method.getBody());
        methodSource.setVisibility(this.buildVisibility(method.getVisibilty()));
        for (org.kie.workbench.common.services.datamodeller.core.Annotation annotation : method.getAnnotations()) {
            this.addAnnotation((AnnotationTargetSource)methodSource, annotation);
        }
    }

    private String buildMethodReturnTypeString(org.kie.workbench.common.services.datamodeller.core.Type methodReturnType, ClassTypeResolver classTypeResolver) throws ClassNotFoundException {
        if (methodReturnType == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.resolveTypeName(classTypeResolver, methodReturnType.getName()));
        this.buildTypeArgumentsString(methodReturnType.getTypeArguments(), classTypeResolver, builder);
        return builder.toString();
    }

    private String buildMethodParameterString(List<Parameter> methodParameters, ClassTypeResolver classTypeResolver) throws ClassNotFoundException {
        if (methodParameters == null || methodParameters.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Parameter> iterator = methodParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            org.kie.workbench.common.services.datamodeller.core.Type parameterType = parameter.getType();
            builder.append(this.resolveTypeName(classTypeResolver, parameterType.getName()));
            this.buildTypeArgumentsString(parameter.getType().getTypeArguments(), classTypeResolver, builder);
            builder.append(" ");
            builder.append(parameter.getName());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private Visibility buildVisibility(org.kie.workbench.common.services.datamodeller.core.Visibility visibility) {
        if (visibility == null) {
            return Visibility.PACKAGE_PRIVATE;
        }
        return DriverUtils.buildVisibility(visibility);
    }

    private void buildTypeArgumentsString(List<org.kie.workbench.common.services.datamodeller.core.Type> typeArguments, ClassTypeResolver classTypeResolver, StringBuilder builder) throws ClassNotFoundException {
        if (typeArguments == null || typeArguments.isEmpty()) {
            return;
        }
        builder.append("<");
        Iterator<org.kie.workbench.common.services.datamodeller.core.Type> iterator = typeArguments.iterator();
        while (iterator.hasNext()) {
            org.kie.workbench.common.services.datamodeller.core.Type argument = iterator.next();
            builder.append(this.resolveTypeName(classTypeResolver, argument.getName()));
            this.buildTypeArgumentsString(argument.getTypeArguments(), classTypeResolver, builder);
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(">");
    }

    public void createField(JavaClassSource javaClassSource, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        GenerationContext generationContext = new GenerationContext(null);
        GenerationTools genTools = new GenerationTools();
        try {
            GenerationEngine engine = GenerationEngine.getInstance();
            String fieldSource = genTools.indent(engine.generateCompleteFieldString(generationContext, property));
            javaClassSource.addField(fieldSource);
            String methodSource = genTools.indent(engine.generateFieldGetterString(generationContext, property));
            String methodName = genTools.toJavaGetter(property.getName(), property.getClassName());
            this.removeMethodByParamsClassName(javaClassSource, methodName, new String[0]);
            javaClassSource.addMethod(methodSource);
            methodSource = genTools.indent(engine.generateFieldSetterString(generationContext, property));
            methodName = genTools.toJavaSetter(property.getName());
            this.removeMethodByParamsClassName(javaClassSource, methodName, property.getClassName());
            javaClassSource.addMethod(methodSource);
        }
        catch (Exception e) {
            logger.error("Field: " + property.getName() + " couldn't be created.", (Throwable)e);
            throw e;
        }
    }

    public void updateField(JavaClassSource javaClassSource, String fieldName, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        GenerationTools genTools = new GenerationTools();
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationContext context = new GenerationContext(null);
        boolean updateAccessors = false;
        FieldSource field = javaClassSource.getField(fieldName);
        Type oldType = field.getType();
        if (this.hasChangedToCollectionType((FieldSource<JavaClassSource>)field, property, classTypeResolver)) {
            this.updateCollectionField(javaClassSource, fieldName, property, classTypeResolver);
        } else {
            if (!fieldName.equals(property.getName())) {
                field.setName(property.getName());
                updateAccessors = true;
            }
            if (DriverUtils.isManagedType(field.getType(), classTypeResolver) && !DriverUtils.equalsType(field.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver)) {
                String newClassName = property.getClassName();
                field.setType(newClassName);
                if (field.getLiteralInitializer() != null) {
                    if (NamingUtils.isPrimitiveTypeId(newClassName)) {
                        this.setPrimitiveTypeDefaultInitializer(field, newClassName);
                    } else {
                        field.setLiteralInitializer(null);
                    }
                }
                updateAccessors = true;
            }
            this.updateAnnotations((AnnotationTargetSource)field, property.getAnnotations(), classTypeResolver);
            if (updateAccessors) {
                Class oldClass = classTypeResolver.resolveType(oldType.getName());
                String oldClassName = oldClass.getName();
                String accessorName = genTools.toJavaGetter(fieldName, oldClassName);
                this.removeMethodByParamsClass(javaClassSource, accessorName, new Class[0]);
                accessorName = genTools.toJavaSetter(fieldName);
                this.removeMethodByParamsClass(javaClassSource, accessorName, oldClass);
                String methodSource = genTools.indent(engine.generateFieldGetterString(context, property));
                javaClassSource.addMethod(methodSource);
                methodSource = genTools.indent(engine.generateFieldSetterString(context, property));
                javaClassSource.addMethod(methodSource);
            }
        }
    }

    private void updateCollectionField(JavaClassSource javaClassSource, String fieldName, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        GenerationTools genTools = new GenerationTools();
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationContext context = new GenerationContext(null);
        boolean updateAccessors = true;
        FieldSource currentField = javaClassSource.getField(fieldName);
        Type currentType = currentField.getType();
        StringBuilder fieldSource = new StringBuilder();
        fieldSource.append(engine.generateCompleteFieldString(context, property));
        javaClassSource.removeField((Field)currentField);
        javaClassSource.addField(fieldSource.toString());
        if (updateAccessors) {
            Class oldClass = classTypeResolver.resolveType(currentType.getName());
            String oldClassName = oldClass.getName();
            String accessorName = genTools.toJavaGetter(fieldName, oldClassName);
            this.removeMethodByParamsClass(javaClassSource, accessorName, new Class[0]);
            accessorName = genTools.toJavaSetter(fieldName);
            this.removeMethodByParamsClass(javaClassSource, accessorName, oldClass);
            String methodSource = genTools.indent(engine.generateFieldGetterString(context, property));
            javaClassSource.addMethod(methodSource);
            methodSource = genTools.indent(engine.generateFieldSetterString(context, property));
            javaClassSource.addMethod(methodSource);
        }
    }

    private boolean hasChangedToCollectionType(FieldSource<JavaClassSource> field, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        return DriverUtils.isManagedType(field.getType(), classTypeResolver) && !DriverUtils.equalsType(field.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver) && property.isMultiple();
    }

    public void updateConstructors(JavaClassSource javaClassSource, DataObject dataObject, List<MethodSource<JavaClassSource>> allFieldsConstructorCandidates, List<MethodSource<JavaClassSource>> keyFieldsConstructorCandidates, List<MethodSource<JavaClassSource>> positionFieldsConstructorCandidates, ClassTypeResolver classTypeResolver) throws Exception {
        String keyFieldsConstructorSource;
        String positionFieldsConstructorSource;
        String allFieldsConstructorSource;
        MethodSource newConstructor;
        GenerationContext generationContext = new GenerationContext(null);
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationTools genTools = new GenerationTools();
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        List<MethodSource<JavaClassSource>> currentAllFieldsConstructors = modelDriver.filterGeneratedConstructors(allFieldsConstructorCandidates);
        List<MethodSource<JavaClassSource>> currentKeyFieldsConstructors = modelDriver.filterGeneratedConstructors(keyFieldsConstructorCandidates);
        List<MethodSource<JavaClassSource>> currentPositionFieldsConstructors = modelDriver.filterGeneratedConstructors(positionFieldsConstructorCandidates);
        if (logger.isDebugEnabled()) {
            logger.debug("allFieldsConstructorCandidates candidates: " + allFieldsConstructorCandidates.size());
            logger.debug(allFieldsConstructorCandidates.size() > 0 ? allFieldsConstructorCandidates.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("currentAllFieldsConstructors: " + currentAllFieldsConstructors.size());
            logger.debug(currentAllFieldsConstructors.size() > 0 ? currentAllFieldsConstructors.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("KeyFieldsConstructorCandidates: " + keyFieldsConstructorCandidates.size());
            logger.debug(keyFieldsConstructorCandidates.size() > 0 ? keyFieldsConstructorCandidates.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("currentKeyFieldsConstructors: " + currentKeyFieldsConstructors.size());
            logger.debug(currentKeyFieldsConstructors.size() > 0 ? currentKeyFieldsConstructors.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("positionFieldsConstructorCandidates: " + positionFieldsConstructorCandidates.size());
            logger.debug(positionFieldsConstructorCandidates.size() > 0 ? positionFieldsConstructorCandidates.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("currentPositionFieldsConstructors: " + currentPositionFieldsConstructors.size());
            logger.debug(currentPositionFieldsConstructors.size() > 0 ? currentPositionFieldsConstructors.get(0).toString() : "");
            logger.debug("\n\n");
        }
        for (MethodSource<JavaClassSource> constructor : currentAllFieldsConstructors) {
            javaClassSource.removeMethod(constructor);
        }
        for (MethodSource<JavaClassSource> constructor : currentKeyFieldsConstructors) {
            javaClassSource.removeMethod(constructor);
        }
        for (MethodSource<JavaClassSource> constructor : currentPositionFieldsConstructors) {
            javaClassSource.removeMethod(constructor);
        }
        List fields = javaClassSource.getFields();
        if (fields != null && fields.size() > 0) {
            int fileOrder = 0;
            for (FieldSource field : fields) {
                ObjectPropertyImpl objectProperty = (ObjectPropertyImpl)dataObject.getProperty(field.getName());
                if (objectProperty != null) {
                    objectProperty.setFileOrder(fileOrder);
                }
                ++fileOrder;
            }
        }
        List<ObjectProperty> allFields = DataModelUtils.sortByFileOrder(DataModelUtils.filterAssignableFields(dataObject));
        List<ObjectProperty> positionFields = DataModelUtils.sortByPosition(DataModelUtils.filterPositionFields(dataObject));
        List<ObjectProperty> keyFields = DataModelUtils.sortByFileOrder(DataModelUtils.filterKeyFields(dataObject));
        boolean needsEmptyConstructor = true;
        boolean needsAllFieldsConstructor = allFields.size() > 0;
        boolean needsPositionFieldsConstructor = positionFields.size() > 0 && !DataModelUtils.equalsByFieldName(allFields, positionFields) && !DataModelUtils.equalsByFieldType(allFields, positionFields);
        boolean needsKeyFieldsConstructor = keyFields.size() > 0 && !DataModelUtils.equalsByFieldName(allFields, keyFields) && !DataModelUtils.equalsByFieldType(allFields, keyFields) && !DataModelUtils.equalsByFieldName(positionFields, keyFields) && !DataModelUtils.equalsByFieldType(positionFields, keyFields);
        ArrayList<MethodSource> currentConstructors = new ArrayList<MethodSource>();
        MethodSource currentEquals = null;
        MethodSource currentHashCode = null;
        List methods = javaClassSource.getMethods();
        if (methods != null) {
            for (MethodSource method : methods) {
                if (method.isConstructor()) {
                    currentConstructors.add(method);
                    if (method.getParameters() != null && method.getParameters().size() != 0) continue;
                    needsEmptyConstructor = false;
                    continue;
                }
                if (this.isEquals(method)) {
                    currentEquals = method;
                    continue;
                }
                if (!this.isHashCode(method)) continue;
                currentHashCode = method;
            }
        }
        needsAllFieldsConstructor = needsAllFieldsConstructor && this.findMatchingConstructorsByTypes(javaClassSource, allFields, classTypeResolver).size() == 0;
        needsPositionFieldsConstructor = needsPositionFieldsConstructor && this.findMatchingConstructorsByTypes(javaClassSource, positionFields, classTypeResolver).size() == 0;
        boolean bl = needsKeyFieldsConstructor = needsKeyFieldsConstructor && this.findMatchingConstructorsByTypes(javaClassSource, keyFields, classTypeResolver).size() == 0;
        if (currentEquals != null) {
            javaClassSource.removeMethod(currentEquals);
        }
        if (currentHashCode != null) {
            javaClassSource.removeMethod(currentHashCode);
        }
        if (needsEmptyConstructor) {
            String defaultConstructorSource = genTools.indent(engine.generateDefaultConstructorString(generationContext, dataObject));
            newConstructor = javaClassSource.addMethod(defaultConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (needsAllFieldsConstructor && (allFieldsConstructorSource = genTools.indent(engine.generateAllFieldsConstructorString(generationContext, dataObject))) != null && !allFieldsConstructorSource.trim().isEmpty()) {
            newConstructor = javaClassSource.addMethod(allFieldsConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (needsPositionFieldsConstructor && (positionFieldsConstructorSource = genTools.indent(engine.generatePositionFieldsConstructorString(generationContext, dataObject))) != null && !positionFieldsConstructorSource.trim().isEmpty()) {
            newConstructor = javaClassSource.addMethod(positionFieldsConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (needsKeyFieldsConstructor && (keyFieldsConstructorSource = genTools.indent(engine.generateKeyFieldsConstructorString(generationContext, dataObject))) != null && !keyFieldsConstructorSource.trim().isEmpty()) {
            newConstructor = javaClassSource.addMethod(keyFieldsConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (keyFields.size() > 0) {
            String equalsMethodSource = genTools.indent(engine.generateEqualsString(generationContext, dataObject));
            javaClassSource.addMethod(equalsMethodSource);
            String hashCodeMethodSource = genTools.indent(engine.generateHashCodeString(generationContext, dataObject));
            javaClassSource.addMethod(hashCodeMethodSource);
        }
    }

    public void removeField(JavaClassSource javaClassSource, String fieldName, ClassTypeResolver classTypeResolver) throws Exception {
        logger.debug("Removing field: " + fieldName + ", from class: " + javaClassSource.getName());
        GenerationTools genTools = new GenerationTools();
        FieldSource field = javaClassSource.getField(fieldName);
        if (field != null) {
            Class fieldClass = classTypeResolver.resolveType(field.getType().getName());
            String methodName = genTools.toJavaGetter(fieldName, fieldClass.getName());
            this.removeMethodByParamsClass(javaClassSource, methodName, new Class[0]);
            methodName = genTools.toJavaSetter(fieldName);
            this.removeMethodByParamsClass(javaClassSource, methodName, fieldClass);
            javaClassSource.removeField((Field)field);
        } else {
            logger.debug("Field field: " + fieldName + " was not found in class: " + javaClassSource.getName());
        }
    }

    public void removeMethodByParamsClass(JavaClassSource javaClassSource, String methodName, Class<?> ... paramTypes) {
        logger.debug("Removing method: " + methodName + ", form class: " + javaClassSource.getName());
        MethodSource method = javaClassSource.getMethod(methodName, (Class[])paramTypes);
        if (method != null) {
            javaClassSource.removeMethod((org.jboss.forge.roaster.model.Method)method);
            logger.debug("Method method: " + methodName + ", was removed from class: " + javaClassSource.getName());
        } else {
            logger.debug("Method method: " + methodName + " not exists for class: " + javaClassSource.getName());
        }
    }

    public void removeMethodByParamsClassName(JavaClassSource javaClassSource, String methodName, String ... paramTypes) {
        logger.debug("Removing method: " + methodName + ", form class: " + javaClassSource.getName());
        MethodSource method = javaClassSource.getMethod(methodName, paramTypes);
        if (method != null) {
            javaClassSource.removeMethod((org.jboss.forge.roaster.model.Method)method);
            logger.debug("Method method: " + methodName + ", was removed from class: " + javaClassSource.getName());
        } else {
            logger.debug("Method method: " + methodName + " not exists for class: " + javaClassSource.getName());
        }
    }

    public List<MethodSource<JavaClassSource>> findAllFieldsConstructorCandidates(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        return this.findMatchingConstructorsByParameters(javaClassSource, properties, classTypeResolver);
    }

    public List<MethodSource<JavaClassSource>> findKeyFieldsConstructorCandidates(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        List<ObjectProperty> keyFields = DataModelUtils.filterKeyFields(properties);
        return this.findMatchingConstructorsByParameters(javaClassSource, keyFields, classTypeResolver);
    }

    public List<MethodSource<JavaClassSource>> findPositionFieldsConstructorCandidates(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        List<ObjectProperty> positionalFields = DataModelUtils.filterPositionFields(properties);
        return this.findMatchingConstructorsByParameters(javaClassSource, DataModelUtils.sortByPosition(positionalFields), classTypeResolver);
    }

    public List<MethodSource<JavaClassSource>> findMatchingConstructorsByParameters(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        ArrayList<MethodSource<JavaClassSource>> result = new ArrayList<MethodSource<JavaClassSource>>();
        List<MethodSource<JavaClassSource>> constructors = this.getConstructors(javaClassSource);
        for (MethodSource<JavaClassSource> constructor : constructors) {
            List parameters = constructor.getParameters();
            if (parameters == null || parameters.size() == 0 || parameters.size() != properties.size()) continue;
            int unmatchedParams = parameters.size();
            int paramIndex = 0;
            for (ParameterSource param : parameters) {
                if (this.paramMatchesWithProperty((ParameterSource<JavaClassSource>)param, properties.get(paramIndex), classTypeResolver)) {
                    --unmatchedParams;
                }
                ++paramIndex;
            }
            if (unmatchedParams != 0) continue;
            result.add(constructor);
        }
        return result;
    }

    public List<MethodSource<JavaClassSource>> findMatchingConstructorsByTypes(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        ArrayList<MethodSource<JavaClassSource>> result = new ArrayList<MethodSource<JavaClassSource>>();
        List<MethodSource<JavaClassSource>> constructors = this.getConstructors(javaClassSource);
        for (MethodSource<JavaClassSource> constructor : constructors) {
            ParameterSource param;
            List parameters = constructor.getParameters();
            if (parameters == null || parameters.size() == 0 || parameters.size() != properties.size()) continue;
            int unmatchedParams = parameters.size();
            int paramIndex = 0;
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext() && this.paramMatchesWithPropertyType((ParameterSource<JavaClassSource>)(param = (ParameterSource)iterator.next()), properties.get(paramIndex), classTypeResolver)) {
                --unmatchedParams;
                ++paramIndex;
            }
            if (unmatchedParams != 0) continue;
            result.add(constructor);
        }
        return result;
    }

    public boolean paramMatchesWithProperty(ParameterSource<JavaClassSource> param, ObjectProperty property, ClassTypeResolver classTypeResolver) {
        if (!param.getName().equals(property.getName())) {
            return false;
        }
        try {
            return DriverUtils.equalsType(param.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver);
        }
        catch (Exception e) {
            logger.error("An error was produced on parameter matching test with param: " + param.getName() + " and field: " + property.getName(), (Throwable)e);
            return false;
        }
    }

    public boolean paramMatchesWithPropertyType(ParameterSource<JavaClassSource> param, ObjectProperty property, ClassTypeResolver classTypeResolver) {
        try {
            return DriverUtils.equalsType(param.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver);
        }
        catch (Exception e) {
            logger.error("An error was produced on parameter matching test with param: " + param.getName() + " and field: " + property.getName(), (Throwable)e);
            return false;
        }
    }

    public List<MethodSource<JavaClassSource>> filterGeneratedConstructors(List<MethodSource<JavaClassSource>> constructors) {
        ArrayList<MethodSource<JavaClassSource>> result = new ArrayList<MethodSource<JavaClassSource>>();
        if (constructors != null) {
            for (MethodSource<JavaClassSource> constructor : constructors) {
                if (!this.isGeneratedConstructor(constructor)) continue;
                result.add(constructor);
            }
        }
        return result;
    }

    public boolean isGeneratedConstructor(MethodSource<JavaClassSource> constructor) {
        String body;
        if (constructor.isAbstract() || constructor.isStatic() || constructor.isFinal()) {
            return false;
        }
        if (!constructor.isPublic()) {
            return false;
        }
        if (constructor.getAnnotations() != null && constructor.getAnnotations().size() > 0) {
            return false;
        }
        List parameters = constructor.getParameters();
        ArrayList<String> expectedLines = new ArrayList<String>();
        if (parameters != null) {
            for (ParameterSource param : parameters) {
                if (param.getAnnotations() != null && param.getAnnotations().size() > 0) {
                    return false;
                }
                String expectedLine = "this." + param.getName() + "=" + param.getName() + ";";
                expectedLines.add(expectedLine);
            }
        }
        if ((body = constructor.getBody()) == null || (body = body.trim()).isEmpty()) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(body));
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                if (++lineNumber > expectedLines.size()) {
                    return false;
                }
                if (line.trim().equals(expectedLines.get(lineNumber - 1))) continue;
                return false;
            }
            return lineNumber == expectedLines.size();
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<MethodSource<JavaClassSource>> getConstructors(JavaClassSource javaClassSource) {
        ArrayList<MethodSource<JavaClassSource>> constructors = new ArrayList<MethodSource<JavaClassSource>>();
        List methods = javaClassSource.getMethods();
        if (methods != null) {
            for (MethodSource method : methods) {
                if (!method.isConstructor()) continue;
                constructors.add((MethodSource<JavaClassSource>)method);
            }
        }
        return constructors;
    }

    public boolean isManagedField(FieldSource<JavaClassSource> field, ClassTypeResolver classTypeResolver) throws Exception {
        if (!field.isFinal() && !field.isStatic()) {
            return DriverUtils.isManagedType(field.getType(), classTypeResolver);
        }
        return false;
    }

    public boolean isEquals(MethodSource<?> method) {
        return method.getName().equals("equals") && (method.getParameters() == null || method.getParameters().size() == 1) && method.getReturnType() != null && method.getReturnType().isPrimitive() && "boolean".equals(method.getReturnType().getName());
    }

    public boolean isHashCode(MethodSource<?> method) {
        return method.getName().equals("hashCode") && (method.getParameters() == null || method.getParameters().size() == 0) && method.getReturnType() != null && method.getReturnType().isPrimitive() && "int".equals(method.getReturnType().getName());
    }

    public void setPrimitiveTypeDefaultInitializer(FieldSource<?> field, String primitiveType) {
        if ("byte".equals(primitiveType)) {
            field.setLiteralInitializer("0");
        }
        if ("short".equals(primitiveType)) {
            field.setLiteralInitializer("0");
        }
        if ("int".equals(primitiveType)) {
            field.setLiteralInitializer("0");
        }
        if ("long".equals(primitiveType)) {
            field.setLiteralInitializer("0L");
        }
        if ("float".equals(primitiveType)) {
            field.setLiteralInitializer("0.0f");
        }
        if ("double".equals(primitiveType)) {
            field.setLiteralInitializer("0.0d");
        }
        if ("char".equals(primitiveType)) {
            field.setLiteralInitializer("'\\u0000'");
        }
        if ("boolean".equals(primitiveType)) {
            field.setLiteralInitializer("false");
        }
    }

    public Pair<org.kie.workbench.common.services.datamodeller.core.Annotation, List<DriverError>> parseAnnotationWithValuePair(String annotationClassName, ElementType target, String valuePairName, String literalValue, ClassLoader classLoader) {
        ArrayList<DriverError> driverErrors = new ArrayList<DriverError>();
        org.kie.workbench.common.services.datamodeller.core.Annotation annotation = null;
        Pair<org.jboss.forge.roaster.model.source.AnnotationSource<JavaClassSource>, List<DriverError>> parseResult = this.parseAnnotationWithValuePair(annotationClassName, target, valuePairName, literalValue);
        driverErrors.addAll((Collection)parseResult.getK2());
        if (driverErrors.size() == 0) {
            ClassTypeResolver classTypeResolver = new ClassTypeResolver(Collections.emptySet(), classLoader);
            try {
                annotation = this.createAnnotation((org.jboss.forge.roaster.model.source.AnnotationSource)parseResult.getK1(), classTypeResolver);
            }
            catch (Exception e) {
                driverErrors.add(new DriverError(e.getMessage()));
            }
        }
        return new Pair(annotation, driverErrors);
    }

    public Pair<org.jboss.forge.roaster.model.source.AnnotationSource<JavaClassSource>, List<DriverError>> parseAnnotationWithValuePair(String annotationClassName, ElementType target, String valuePairName, String literalValue) {
        ArrayList<DriverError> syntaxErrors = new ArrayList<DriverError>();
        String annotationStr = "@" + annotationClassName + "(" + valuePairName + "=" + literalValue + " )";
        org.jboss.forge.roaster.model.source.AnnotationSource annotation = null;
        String stub = ElementType.TYPE.equals((Object)target) ? annotationStr + " public class Stub { }" : "public class Stub { " + annotationStr + " int dummy; }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse(JavaClass.class, (String)stub);
        if (temp.getSyntaxErrors() != null && temp.getSyntaxErrors().size() > 0) {
            for (SyntaxError syntaxError : temp.getSyntaxErrors()) {
                syntaxErrors.add(new DriverError(syntaxError.getDescription(), syntaxError.getLine(), syntaxError.getColumn()));
            }
        } else {
            annotation = ElementType.TYPE.equals((Object)target) ? temp.getAnnotation(annotationClassName) : temp.getField("dummy").getAnnotation(annotationClassName);
        }
        if (annotation == null) {
            syntaxErrors.add(new DriverError("Annotation value pair could not be parsed."));
        }
        return new Pair((Object)annotation, syntaxErrors);
    }

    public boolean isManagedAnnotation(org.jboss.forge.roaster.model.source.AnnotationSource<?> annotation, ClassTypeResolver classTypeResolver) throws Exception {
        String annotationClassName = this.resolveTypeName(classTypeResolver, annotation.getName());
        return this.getConfiguredAnnotation(annotationClassName) != null;
    }

    private String errorMessage(String message, Object ... params) {
        return MessageFormat.format(message, params);
    }
}

