/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.drools.core.base.ClassTypeResolver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassOrInterfaceTypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.FileDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierWithTypeArgumentsDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ImportDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeArgumentDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeArgumentListDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;

public class JavaDriverUtils {
    public static ClassTypeResolver createClassTypeResolver(FileDescr fileDescr, ClassLoader classLoader) {
        String packageName;
        HashSet<String> classImports = new HashSet<String>();
        List<ImportDescr> fileImports = fileDescr.getImports();
        if (fileImports != null) {
            for (ImportDescr importDescr : fileDescr.getImports()) {
                classImports.add(importDescr.getName(true));
            }
        }
        if ((packageName = fileDescr.getPackageDescr() != null ? fileDescr.getPackageDescr().getPackageName() : null) != null && !"".equals(packageName)) {
            classImports.add(packageName + ".*");
        }
        return new ClassTypeResolver(classImports, classLoader);
    }

    public static boolean isPrimitiveType(TypeDescr typeDescr) {
        return typeDescr.isPrimitiveType();
    }

    public static boolean isSimpleClass(TypeDescr typeDescr) {
        if (!typeDescr.isClassOrInterfaceType()) {
            return false;
        }
        ClassOrInterfaceTypeDescr classOrInterfaceTypeDescr = typeDescr.getClassOrInterfaceType();
        List<IdentifierWithTypeArgumentsDescr> identifierWithTypeArgumentsList = classOrInterfaceTypeDescr.getIdentifierWithTypeArguments();
        if (identifierWithTypeArgumentsList == null || identifierWithTypeArgumentsList.size() == 0) {
            return false;
        }
        for (IdentifierWithTypeArgumentsDescr identifierWithTypeArguments : identifierWithTypeArgumentsList) {
            if (identifierWithTypeArguments.getArguments() == null) continue;
            return false;
        }
        return true;
    }

    public static Object[] isSimpleGeneric(TypeDescr typeDescr) {
        Object[] result = new Object[]{false, null, null};
        if (!typeDescr.isClassOrInterfaceType()) {
            return result;
        }
        ClassOrInterfaceTypeDescr classOrInterfaceTypeDescr = typeDescr.getClassOrInterfaceType();
        List<IdentifierWithTypeArgumentsDescr> identifierWithTypeArgumentsList = classOrInterfaceTypeDescr.getIdentifierWithTypeArguments();
        if (identifierWithTypeArgumentsList == null || identifierWithTypeArgumentsList.size() == 0) {
            return result;
        }
        int i = 0;
        StringBuilder outerClassName = new StringBuilder();
        for (IdentifierWithTypeArgumentsDescr identifierWithTypeArguments : identifierWithTypeArgumentsList) {
            List<TypeArgumentDescr> typeArguments;
            if (++i > 1) {
                outerClassName.append(".");
            }
            outerClassName.append(identifierWithTypeArguments.getIdentifier().getIdentifier());
            if (identifierWithTypeArguments.getArguments() == null) continue;
            if (identifierWithTypeArgumentsList.size() > i) {
                return result;
            }
            TypeArgumentListDescr typeArgumentList = identifierWithTypeArguments.getArguments();
            List<TypeArgumentDescr> list = typeArguments = typeArgumentList != null ? typeArgumentList.getArguments() : null;
            if (typeArguments == null || typeArguments.size() != 1) {
                return result;
            }
            TypeDescr type = typeArguments.get(0).getType();
            if (type == null || !JavaDriverUtils.isSimpleClass(type)) continue;
            result[0] = true;
            result[1] = outerClassName.toString();
            result[2] = type;
            return result;
        }
        return result;
    }

    public static boolean isArray(TypeDescr typeDescr) {
        return typeDescr.getDimensionsCount() > 0;
    }

    public static boolean isManagedType(TypeDescr typeDescr, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        if (JavaDriverUtils.isArray(typeDescr)) {
            return false;
        }
        if (JavaDriverUtils.isPrimitiveType(typeDescr) || JavaDriverUtils.isSimpleClass(typeDescr)) {
            return true;
        }
        Object[] simpleGenerics = JavaDriverUtils.isSimpleGeneric(typeDescr);
        if (Boolean.FALSE.equals(simpleGenerics[0])) {
            return false;
        }
        String collectionCandidate = simpleGenerics[1].toString();
        try {
            Class collectionCandidateClass = classTypeResolver.resolveType(collectionCandidate);
            return Collection.class.isAssignableFrom(collectionCandidateClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelDriverException("Class could not be resolved for name: " + collectionCandidate + ". " + e.getMessage(), e);
        }
    }

    public static boolean equalsType(TypeDescr type, String fullClassName, boolean multiple, String fullBagClassName, ClassTypeResolver classTypeResolver) throws ClassNotFoundException {
        if (JavaDriverUtils.isArray(type)) {
            return false;
        }
        if (type.isPrimitiveType()) {
            return !multiple && fullClassName.equals(type.getPrimitiveType().getName());
        }
        if (JavaDriverUtils.isSimpleClass(type)) {
            String currentClassName = classTypeResolver.getFullTypeName(type.getClassOrInterfaceType().getClassName());
            return !multiple && fullClassName.equals(currentClassName);
        }
        Object[] simpleGenerics = JavaDriverUtils.isSimpleGeneric(type);
        if (Boolean.TRUE.equals(simpleGenerics[0]) && multiple) {
            String currentBag = (String)simpleGenerics[1];
            currentBag = classTypeResolver.getFullTypeName(currentBag);
            String currentClassName = ((TypeDescr)simpleGenerics[2]).getClassOrInterfaceType().getClassName();
            currentClassName = classTypeResolver.getFullTypeName(currentClassName);
            return fullBagClassName.equals(currentBag) && fullClassName.equals(currentClassName);
        }
        return false;
    }

    public static int buildModifierRepresentation(List<ModifierDescr> modifiers) {
        int result = 0;
        if (modifiers != null) {
            for (ModifierDescr modifier : modifiers) {
                if ("public".equals(modifier.getName())) {
                    result |= 1;
                }
                if ("protected".equals(modifier.getName())) {
                    result |= 4;
                }
                if ("private".equals(modifier.getName())) {
                    result |= 2;
                }
                if ("abstract".equals(modifier.getName())) {
                    result |= 0x400;
                }
                if ("static".equals(modifier.getName())) {
                    result |= 8;
                }
                if ("final".equals(modifier.getName())) {
                    result |= 0x10;
                }
                if ("transient".equals(modifier.getName())) {
                    result |= 0x80;
                }
                if ("volatile".equals(modifier.getName())) {
                    result |= 0x40;
                }
                if ("synchronized".equals(modifier.getName())) {
                    result |= 0x20;
                }
                if ("native".equals(modifier.getName())) {
                    result |= 0x100;
                }
                if ("strictfp".equals(modifier.getName())) {
                    result |= 0x800;
                }
                if (!"interface".equals(modifier.getName())) continue;
                result |= 0x200;
            }
        }
        return result;
    }
}

