/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.user.client.ui.IsWidget;
import org.drools.guvnor.client.AppController;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.FindPlace;
import org.drools.guvnor.client.explorer.MultiActivityManager;
import org.drools.guvnor.client.perspective.PerspectivesPanel;

public class AppControllerImpl
implements AppController {
    private final ClientFactory clientFactory;
    private final PerspectivesPanel perspectivesPanel;
    private final EventBus eventBus;

    public AppControllerImpl(ClientFactory clientFactory, EventBus eventBus) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.perspectivesPanel = this.createPerspectivesPanel();
        this.setUpActivityMapper();
        this.setUpHistoryMapper();
    }

    private void setUpHistoryMapper() {
        PlaceHistoryHandler historyHandler = this.clientFactory.getPlaceHistoryHandler();
        historyHandler.register(this.clientFactory.getPlaceController(), this.eventBus, (Place)new FindPlace());
    }

    private PerspectivesPanel createPerspectivesPanel() {
        return new PerspectivesPanel(this.clientFactory, this.eventBus);
    }

    private void setUpActivityMapper() {
        MultiActivityManager activityManager = this.clientFactory.getActivityManager();
        activityManager.setTabbedPanel(this.perspectivesPanel.getTabbedPanel());
    }

    @Override
    public IsWidget getMainPanel() {
        return this.perspectivesPanel.getView();
    }

    @Override
    public void setUserName(String userName) {
        this.perspectivesPanel.setUserName(userName);
    }
}

