/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.ruleflow;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowBaseNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitTransferNode;
import org.drools.guvnor.client.messages.ConstantsCore;

public class SplitNode
extends RuleFlowBaseNode {
    SplitTransferNode.Type type;
    public Map<ConnectionRef, Constraint> constraints;
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);

    @Override
    public RuleFlowBaseNode.Corners getCorners() {
        return RuleFlowBaseNode.Corners.ROUND;
    }

    @Override
    public ImageResource getImagePath() {
        return null;
    }

    @Override
    public String getStyle() {
        return "blue-ruleflow-node";
    }

    public void onClick(Widget arg0) {
        if (this.parametersForm != null) {
            this.parametersForm.clear();
            this.parametersForm.addAttribute(this.constants.Type2(), (Widget)new Label(this.type.toString()));
            for (final ConnectionRef connectionRef : this.constraints.keySet()) {
                Constraint constraint = this.constraints.get(connectionRef);
                final TextBox priorityTextBox = new TextBox();
                priorityTextBox.setWidth("30px");
                priorityTextBox.setText(constraint.getPriority() + "");
                priorityTextBox.addFocusHandler(new FocusHandler(){

                    public void onFocus(FocusEvent event) {
                        priorityTextBox.selectAll();
                    }
                });
                priorityTextBox.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        Constraint constraint = SplitNode.this.constraints.get(connectionRef);
                        constraint.setPriority(Integer.parseInt(priorityTextBox.getText()));
                        SplitNode.this.constraints.put(connectionRef, constraint);
                    }
                });
                final TextBox constraintTextBox = new TextBox();
                constraintTextBox.setWidth("300px");
                constraintTextBox.setText(constraint.getConstraint());
                constraintTextBox.addFocusHandler(new FocusHandler(){

                    public void onFocus(FocusEvent event) {
                        constraintTextBox.selectAll();
                    }
                });
                constraintTextBox.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        Constraint constraint = SplitNode.this.constraints.get(connectionRef);
                        constraint.setConstraint(constraintTextBox.getText());
                        SplitNode.this.constraints.put(connectionRef, constraint);
                    }
                });
                HorizontalPanel panel = new HorizontalPanel();
                panel.add((Widget)new Label(this.constants.Priority()));
                panel.add((Widget)priorityTextBox);
                panel.add((Widget)new Label(this.constants.ValueRuleFlow()));
                panel.add((Widget)constraintTextBox);
                this.parametersForm.addAttribute(constraint.getName(), (Widget)panel);
            }
        }
    }

    public static class ConnectionRef
    implements IsSerializable {
        private String toType;
        private long nodeId;

        public void setToType(String toType) {
            this.toType = toType;
        }

        public void setNodeId(long nodeId) {
            this.nodeId = nodeId;
        }

        public String getToType() {
            return this.toType;
        }

        public long getNodeId() {
            return this.nodeId;
        }

        public boolean equals(Object o) {
            if (o instanceof ConnectionRef) {
                ConnectionRef c = (ConnectionRef)o;
                return this.toType.equals(c.toType) && this.nodeId == c.nodeId;
            }
            return false;
        }

        public int hashCode() {
            return 7 * this.toType.hashCode() + (int)this.nodeId;
        }
    }

    public static class Constraint
    implements IsSerializable {
        private String constraint;
        private String dialect;
        private int priority;
        private String name;
        private String type;

        public String getConstraint() {
            return this.constraint;
        }

        public String getDialect() {
            return this.dialect;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getType() {
            return this.type;
        }

        public void setConstraint(String constraint) {
            this.constraint = constraint;
        }

        public void setDialect(String dialect) {
            this.dialect = dialect;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

