/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.explorer.navigation.admin.ManagerPlace;
import org.drools.guvnor.client.explorer.navigation.admin.widget.ArchivedAssetManager;
import org.drools.guvnor.client.explorer.navigation.admin.widget.BackupManager;
import org.drools.guvnor.client.explorer.navigation.admin.widget.CategoryManager;
import org.drools.guvnor.client.explorer.navigation.admin.widget.EventLogPresenter;
import org.drools.guvnor.client.explorer.navigation.admin.widget.EventLogViewImpl;
import org.drools.guvnor.client.explorer.navigation.admin.widget.PermissionViewer;
import org.drools.guvnor.client.explorer.navigation.admin.widget.RepoConfigManager;
import org.drools.guvnor.client.explorer.navigation.admin.widget.StateManager;
import org.drools.guvnor.client.explorer.navigation.admin.widget.WorkspaceManager;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.util.Activity;

public class ManagerActivity
extends Activity {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private final int id;
    private final ClientFactory clientFactory;

    public ManagerActivity(int id, ClientFactory clientFactory) {
        this.id = id;
        this.clientFactory = clientFactory;
    }

    @Override
    public void start(AcceptItem tabbedPanel, EventBus eventBus) {
        this.openAdministrationSelection(tabbedPanel, this.id, eventBus);
    }

    public void openAdministrationSelection(AcceptItem tabbedPanel, final int id, final EventBus eventBus) {
        switch (id) {
            case 0: {
                tabbedPanel.add(this.constants.CategoryManager(), (IsWidget)new CategoryManager());
                break;
            }
            case 1: {
                tabbedPanel.add(this.constants.ArchivedManager(), (IsWidget)new ArchivedAssetManager(this.clientFactory, eventBus));
                break;
            }
            case 2: {
                tabbedPanel.add(this.constants.StateManager(), (IsWidget)new StateManager());
                break;
            }
            case 3: {
                tabbedPanel.add(this.constants.ImportExport(), (IsWidget)new BackupManager());
                break;
            }
            case 4: {
                EventLogViewImpl eventLogView = new EventLogViewImpl();
                RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
                new EventLogPresenter(repositoryService, eventLogView);
                tabbedPanel.add(this.constants.EventLog(), eventLogView);
                break;
            }
            case 5: {
                tabbedPanel.add(this.constants.UserPermissionMappings(), (IsWidget)new PermissionViewer());
                break;
            }
            case 6: {
                Frame aboutInfoFrame = new Frame("../AboutInfo.html");
                FormStylePopup aboutPop = new FormStylePopup();
                aboutPop.setWidth("600px");
                aboutPop.setTitle(this.constants.About());
                String hhurl = GWT.getModuleBaseURL() + "webdav";
                aboutPop.addAttribute(this.constants.WebDAVURL() + ":", (Widget)new SmallLabel("<b>" + hhurl + "</b>"));
                aboutPop.addAttribute(this.constants.Version() + ":", (Widget)aboutInfoFrame);
                aboutPop.show();
                aboutPop.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        ManagerPlace place = new ManagerPlace(id);
                        eventBus.fireEvent((GwtEvent)new ClosePlaceEvent(place));
                    }
                });
                break;
            }
            case 8: {
                tabbedPanel.add(this.constants.RepositoryConfig(), (IsWidget)new RepoConfigManager());
                break;
            }
            case 9: {
                tabbedPanel.add(this.constants.Workspaces(), (IsWidget)new WorkspaceManager());
            }
        }
    }
}

