/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;

public class BackupManager
extends Composite {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);

    public BackupManager() {
        PrettyFormLayout widtab = new PrettyFormLayout();
        widtab.addHeader(GuvnorImages.INSTANCE.EditCategories(), (Widget)new HTML(this.constants.ImportOrExport()));
        widtab.startSection(this.constants.ImportFromAnXmlFile());
        widtab.addAttribute("", this.newImportWidget());
        widtab.endSection();
        widtab.startSection(this.constants.ExportToAZipFile());
        widtab.addAttribute("", this.newExportWidget());
        widtab.endSection();
        this.initWidget((Widget)widtab);
    }

    private Widget newExportWidget() {
        HorizontalPanel horiz = new HorizontalPanel();
        Button create = new Button(this.constants.Export());
        create.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                BackupManager.this.exportRepository();
            }
        });
        horiz.add((Widget)create);
        return horiz;
    }

    private Widget newImportWidget() {
        final FormPanel uploadFormPanel = new FormPanel();
        uploadFormPanel.setAction(GWT.getModuleBaseURL() + "backup");
        uploadFormPanel.setEncoding("multipart/form-data");
        uploadFormPanel.setMethod("post");
        HorizontalPanel panel = new HorizontalPanel();
        uploadFormPanel.setWidget((Widget)panel);
        final FileUpload upload = new FileUpload();
        upload.setName("importFile");
        upload.setHeight("30px");
        panel.add((Widget)upload);
        panel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
        Button ok = new Button(this.constants.Import());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent sender) {
                this.doImportFile(uploadFormPanel);
            }

            private void doImportFile(FormPanel uploadFormPanel2) {
                if (Window.confirm((String)BackupManager.this.constants.ImportConfirm())) {
                    LoadingPopup.showMessage(BackupManager.this.constants.ImportingInProgress());
                    uploadFormPanel2.submit();
                }
            }
        });
        panel.add((Widget)ok);
        uploadFormPanel.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                if (event.getResults().indexOf("OK") > -1) {
                    Window.alert((String)BackupManager.this.constants.ImportDone());
                    History.newItem((String)" ");
                    Window.Location.reload();
                } else {
                    ErrorPopup.showMessage(BackupManager.this.constants.ImportFailed());
                }
                LoadingPopup.close();
            }
        });
        uploadFormPanel.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                String fileName = upload.getFilename();
                if (fileName.length() == 0) {
                    Window.alert((String)BackupManager.this.constants.NoExportFilename());
                    event.cancel();
                } else {
                    String lowerCaseFileName = fileName.toLowerCase();
                    if (!lowerCaseFileName.endsWith(".xml") && !lowerCaseFileName.endsWith(".zip")) {
                        Window.alert((String)BackupManager.this.constants.PleaseSpecifyAValidRepositoryXmlFile());
                        event.cancel();
                    }
                }
            }
        });
        return uploadFormPanel;
    }

    private void exportRepository() {
        if (Window.confirm((String)this.constants.ExportRepoWarning())) {
            LoadingPopup.showMessage(this.constants.ExportRepoWait());
            Window.open((String)(GWT.getModuleBaseURL() + "backup?" + "exportWholeRepository" + "=true"), (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
            LoadingPopup.close();
        }
    }
}

