/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.perspective;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.perspective.ChangePerspectiveEvent;
import org.drools.guvnor.client.perspective.Perspective;
import org.drools.guvnor.client.perspective.PerspectivesPanelView;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.client.util.TabbedPanel;

public class PerspectivesPanel
implements PerspectivesPanelView.Presenter {
    private final PerspectivesPanelView view;
    private final EventBus eventBus;
    private final ClientFactory clientFactory;

    public PerspectivesPanel(ClientFactory clientFactory, EventBus eventBus) {
        String[] registeredPerspectiveTypes;
        this.eventBus = eventBus;
        this.clientFactory = clientFactory;
        this.view = clientFactory.getNavigationViewFactory().getPerspectivesPanelView();
        this.view.setPresenter(this);
        for (String perspectiveType : registeredPerspectiveTypes = clientFactory.getPerspectiveFactory().getRegisteredPerspectiveTypes()) {
            this.view.addPerspective(perspectiveType, perspectiveType);
        }
        if (registeredPerspectiveTypes != null && registeredPerspectiveTypes.length != 0) {
            this.setPerspective(clientFactory.getPerspectiveFactory().getPerspective(registeredPerspectiveTypes[0]));
        }
    }

    private void setPerspective(Perspective perspective) {
        this.eventBus.fireEvent((GwtEvent)new ChangePerspectiveEvent(perspective));
    }

    public PerspectivesPanelView getView() {
        return this.view;
    }

    public void setUserName(String userName) {
        this.view.setUserName(userName);
    }

    @Override
    public void onChangePerspective(String perspectiveType) {
        this.updateGlobalAreaType(perspectiveType);
        this.setPerspective(this.clientFactory.getPerspectiveFactory().getPerspective(perspectiveType));
    }

    @Override
    public void onLogout() {
        this.clientFactory.getSecurityService().logout(new GenericCallback(){

            public void onSuccess(Object result) {
                Window.open((String)(GWT.getModuleBaseURL() + "Guvnor.jsp"), (String)"_self", (String)"");
            }
        });
    }

    public TabbedPanel getTabbedPanel() {
        return this.view.getTabbedPanel();
    }

    private void updateGlobalAreaType(final String perspectiveType) {
        this.clientFactory.getModuleService().loadGlobalModule((AsyncCallback<Module>)new GenericCallback<Module>(){

            public void onSuccess(Module packageConfigData) {
                if ("author".equals(perspectiveType)) {
                    packageConfigData.setFormat("package");
                } else if ("soaservice".equals(perspectiveType)) {
                    packageConfigData.setFormat("soaservice");
                }
                PerspectivesPanel.this.clientFactory.getModuleService().saveModule(packageConfigData, new GenericCallback<ValidatedResponse>(){

                    public void onSuccess(ValidatedResponse data) {
                    }
                });
            }
        });
    }
}

