/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.util.DecoratedTextArea;

public class CommentWidget
extends DirtyableComposite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private final DecoratedTextArea text = this.getTextArea();

    public CommentWidget(final Artifact artifact, boolean readOnly) {
        this.text.setEnabled(!readOnly);
        DecoratedDisclosurePanel disclosurePanel = this.getDisclosurePanel();
        disclosurePanel.setContent((Widget)this.text);
        disclosurePanel.addOpenHandler(new OpenHandler<DisclosurePanel>(){

            public void onOpen(OpenEvent<DisclosurePanel> event) {
                CommentWidget.this.loadData(artifact);
            }
        });
        disclosurePanel.setOpen(false);
        this.initWidget((Widget)disclosurePanel);
    }

    private DecoratedDisclosurePanel getDisclosurePanel() {
        DecoratedDisclosurePanel disclosurePanel = new DecoratedDisclosurePanel(this.constants.Description());
        disclosurePanel.setWidth("100%");
        return disclosurePanel;
    }

    private DecoratedTextArea getTextArea() {
        DecoratedTextArea text = new DecoratedTextArea();
        text.setWidth("95%");
        text.setVisibleLines(5);
        text.setTitle(this.constants.RuleDocHint());
        return text;
    }

    private void loadData(final Artifact data) {
        this.text.setText(data.getDescription());
        this.text.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                data.setDescription(CommentWidget.this.text.getText());
                CommentWidget.this.makeDirty();
            }
        });
        if (data.getDescription() == null || "".equals(data.getDescription())) {
            this.text.setText(this.constants.documentationDefault());
        }
    }
}

