/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.resources.ComparableImageResource;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.ComparableImageResourceCell;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class AdminArchivedPagedTable
extends AbstractAssetPagedTable<AdminArchivedPageRow> {
    @UiField
    protected Button restoreSelectedAssetButton;
    @UiField
    protected Button deleteSelectedAssetButton;
    private static AdminArchivedPagedTableBinder uiBinder = (AdminArchivedPagedTableBinder)GWT.create(AdminArchivedPagedTableBinder.class);
    private Command restoreSelectedAssetCommand;
    private Command deleteSelectedAssetCommand;
    private static final int PAGE_SIZE = 10;
    private final ClientFactory clientFactory;

    public AdminArchivedPagedTable(Command restoreSelectedAssetCommand, Command deleteSelectedAssetCommand, ClientFactory clientFactory) {
        super(10, clientFactory);
        this.restoreSelectedAssetCommand = restoreSelectedAssetCommand;
        this.deleteSelectedAssetCommand = deleteSelectedAssetCommand;
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<AdminArchivedPageRow>(){

            protected void onRangeChanged(HasData<AdminArchivedPageRow> display) {
                PageRequest request = new PageRequest(AdminArchivedPagedTable.this.pager.getPageStart(), AdminArchivedPagedTable.this.pageSize);
                AdminArchivedPagedTable.this.assetService.loadArchivedAssets(request, (AsyncCallback<PageResponse<AdminArchivedPageRow>>)new GenericCallback<PageResponse<AdminArchivedPageRow>>(){

                    public void onSuccess(PageResponse<AdminArchivedPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<AdminArchivedPageRow> columnPicker, SortableHeaderGroup<AdminArchivedPageRow> sortableHeaderGroup) {
        Column<AdminArchivedPageRow, ComparableImageResource> formatColumn = new Column<AdminArchivedPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(AdminArchivedPageRow row) {
                AssetEditorFactory factory = AdminArchivedPagedTable.this.clientFactory.getAssetEditorFactory();
                return new ComparableImageResource(row.getFormat(), factory.getAssetEditorIcon(row.getFormat()));
            }
        };
        columnPicker.addColumn(formatColumn, new SortableHeader<AdminArchivedPageRow, ComparableImageResource>(sortableHeaderGroup, constants.Format(), formatColumn), true);
        TextColumn<AdminArchivedPageRow> nameColumn = new TextColumn<AdminArchivedPageRow>(){

            public String getValue(AdminArchivedPageRow row) {
                return row.getName();
            }
        };
        columnPicker.addColumn((Column<AdminArchivedPageRow, ?>)nameColumn, new SortableHeader(sortableHeaderGroup, constants.Name(), nameColumn), true);
        TextColumn<AdminArchivedPageRow> packageNameColumn = new TextColumn<AdminArchivedPageRow>(){

            public String getValue(AdminArchivedPageRow row) {
                return row.getPackageName();
            }
        };
        columnPicker.addColumn((Column<AdminArchivedPageRow, ?>)packageNameColumn, new SortableHeader(sortableHeaderGroup, constants.PackageName(), packageNameColumn), false);
        TextColumn<AdminArchivedPageRow> lastContributorColumn = new TextColumn<AdminArchivedPageRow>(){

            public String getValue(AdminArchivedPageRow row) {
                return row.getLastContributor();
            }
        };
        columnPicker.addColumn((Column<AdminArchivedPageRow, ?>)lastContributorColumn, new SortableHeader(sortableHeaderGroup, constants.LastContributor(), lastContributorColumn), true);
        Column<AdminArchivedPageRow, Date> lastModifiedColumn = new Column<AdminArchivedPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(AdminArchivedPageRow row) {
                return row.getLastModified();
            }
        };
        columnPicker.addColumn(lastModifiedColumn, new SortableHeader<AdminArchivedPageRow, Date>(sortableHeaderGroup, constants.LastModified(), lastModifiedColumn), true);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"restoreSelectedAssetButton"})
    void restoreSelectedAsset(ClickEvent e) {
        this.restoreSelectedAssetCommand.execute();
    }

    @UiHandler(value={"deleteSelectedAssetButton"})
    void deleteSelectedAsset(ClickEvent e) {
        this.deleteSelectedAssetCommand.execute();
    }

    static interface AdminArchivedPagedTableBinder
    extends UiBinder<Widget, AdminArchivedPagedTable> {
    }
}

