/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.resources.ComparableImageResource;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.CategoryPageRow;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.ComparableImageResourceCell;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;
import org.drools.guvnor.client.widgets.tables.TitledTextCell;
import org.drools.guvnor.client.widgets.tables.TitledTextColumn;

public class CategoryPagedTable
extends AbstractAssetPagedTable<CategoryPageRow> {
    private static final int PAGE_SIZE = 10;
    private final ClientFactory clientFactory;

    public CategoryPagedTable(final String categoryName, String feedURL, ClientFactory clientFactory) {
        super(10, feedURL, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<CategoryPageRow>(){

            protected void onRangeChanged(HasData<CategoryPageRow> display) {
                CategoryPageRequest request = new CategoryPageRequest();
                request.setCategoryPath(categoryName);
                request.setStartRowIndex(CategoryPagedTable.this.pager.getPageStart());
                request.setPageSize(CategoryPagedTable.this.pageSize);
                CategoryPagedTable.this.categoryService.loadRuleListForCategories(request, (AsyncCallback<PageResponse<CategoryPageRow>>)new GenericCallback<PageResponse<CategoryPageRow>>(){

                    public void onSuccess(PageResponse<CategoryPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<CategoryPageRow> columnPicker, SortableHeaderGroup<CategoryPageRow> sortableHeaderGroup) {
        Column<CategoryPageRow, ComparableImageResource> formatColumn = new Column<CategoryPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(CategoryPageRow row) {
                AssetEditorFactory factory = CategoryPagedTable.this.clientFactory.getAssetEditorFactory();
                return new ComparableImageResource(row.getFormat(), factory.getAssetEditorIcon(row.getFormat()));
            }
        };
        columnPicker.addColumn(formatColumn, new SortableHeader<CategoryPageRow, ComparableImageResource>(sortableHeaderGroup, constants.Format(), formatColumn), true);
        TitledTextColumn<CategoryPageRow> titleColumn = new TitledTextColumn<CategoryPageRow>(){

            public TitledTextCell.TitledText getValue(CategoryPageRow row) {
                return new TitledTextCell.TitledText(row.getName(), row.getAbbreviatedDescription());
            }
        };
        columnPicker.addColumn(titleColumn, new SortableHeader<CategoryPageRow, TitledTextCell.TitledText>(sortableHeaderGroup, constants.Name(), titleColumn), true);
        TextColumn<CategoryPageRow> packageNameColumn = new TextColumn<CategoryPageRow>(){

            public String getValue(CategoryPageRow row) {
                return row.getPackageName();
            }
        };
        columnPicker.addColumn((Column<CategoryPageRow, ?>)packageNameColumn, new SortableHeader(sortableHeaderGroup, constants.PackageName(), packageNameColumn), true);
        TextColumn<CategoryPageRow> statusNameColumn = new TextColumn<CategoryPageRow>(){

            public String getValue(CategoryPageRow row) {
                return row.getStateName();
            }
        };
        columnPicker.addColumn((Column<CategoryPageRow, ?>)statusNameColumn, new SortableHeader(sortableHeaderGroup, constants.Status(), statusNameColumn), true);
        Column<CategoryPageRow, Date> lastModifiedColumn = new Column<CategoryPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(CategoryPageRow row) {
                return row.getLastModified();
            }
        };
        columnPicker.addColumn(lastModifiedColumn, new SortableHeader<CategoryPageRow, Date>(sortableHeaderGroup, constants.LastModified(), lastModifiedColumn), true);
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        for (Command unloadListener : this.unloadListenerSet) {
            unloadListener.execute();
        }
    }
}

