/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.MultiViewRow;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.widgets.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.widgets.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.widgets.query.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.PermissionsPagedTableView;

public class PermissionsPagedTablePresenter
implements PermissionsPagedTableView.Presenter {
    protected RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private final PermissionsPagedTableView view;

    public PermissionsPagedTablePresenter(PermissionsPagedTableView view) {
        this.view = view;
        this.bind();
    }

    public void bind() {
        Command newUserCommand = new Command(){

            public void execute() {
                Image image = new Image(ImagesCore.INSTANCE.snapshot());
                image.setAltText(ConstantsCore.INSTANCE.Snapshot());
                final FormStylePopup form = new FormStylePopup(image, ConstantsCore.INSTANCE.EnterNewUserName());
                final TextBox userName = new TextBox();
                form.addAttribute(ConstantsCore.INSTANCE.NewUserName(), (Widget)userName);
                Button btnOK = new Button(ConstantsCore.INSTANCE.OK());
                form.addAttribute("", (Widget)btnOK);
                btnOK.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (userName.getText() != null && userName.getText().length() != 0) {
                            PermissionsPagedTablePresenter.this.repositoryService.createUser(userName.getText(), new GenericCallback<Void>(){

                                public void onSuccess(Void a) {
                                    PermissionsPagedTablePresenter.this.view.refresh();
                                    PermissionsPagedTablePresenter.this.showEditor(userName.getText());
                                }

                                @Override
                                public void onFailure(Throwable t) {
                                    super.onFailure(t);
                                }
                            });
                            form.hide();
                        }
                    }
                });
                form.show();
            }
        };
        this.view.setNewUserCommand(newUserCommand);
        Command deleteUserCommand = new Command(){

            public void execute() {
                String userName = ((PermissionsPageRow)PermissionsPagedTablePresenter.this.view.getSelectionModel().getSelectedObject()).getUserName();
                if (userName != null && Window.confirm((String)ConstantsCore.INSTANCE.AreYouSureYouWantToDeleteUser0(userName))) {
                    PermissionsPagedTablePresenter.this.repositoryService.deleteUser(userName, new GenericCallback<Void>(){

                        public void onSuccess(Void a) {
                            PermissionsPagedTablePresenter.this.view.refresh();
                        }
                    });
                }
            }
        };
        this.view.setDeleteUserCommand(deleteUserCommand);
        OpenItemCommand openSelectedCommand = new OpenItemCommand(){

            @Override
            public void open(String key) {
                PermissionsPagedTablePresenter.this.showEditor(key);
            }

            @Override
            public void open(MultiViewRow[] rows) {
            }
        };
        this.view.setOpenSelectedCommand(openSelectedCommand);
        AsyncDataProvider<PermissionsPageRow> dataProvider = new AsyncDataProvider<PermissionsPageRow>(){

            protected void onRangeChanged(HasData<PermissionsPageRow> display) {
                PageRequest request = new PageRequest();
                request.setStartRowIndex(((PermissionsPagedTablePresenter)PermissionsPagedTablePresenter.this).view.pager.getPageStart());
                request.setPageSize(((PermissionsPagedTablePresenter)PermissionsPagedTablePresenter.this).view.pageSize);
                PermissionsPagedTablePresenter.this.repositoryService.listUserPermissions(request, (AsyncCallback<PageResponse<PermissionsPageRow>>)new GenericCallback<PageResponse<PermissionsPageRow>>(){

                    public void onSuccess(PageResponse<PermissionsPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        };
        this.view.setDataProvider(dataProvider);
    }

    private void showEditor(final String userName) {
        LoadingPopup.showMessage(ConstantsCore.INSTANCE.LoadingUsersPermissions());
        this.repositoryService.retrieveUserPermissions(userName, new GenericCallback<Map<String, List<String>>>(){

            public void onSuccess(Map<String, List<String>> perms) {
                PermissionsPagedTablePresenter.this.doPermissionEditor(userName, perms);
                LoadingPopup.close();
            }
        });
    }

    private void doPermissionEditor(String userName, Map<String, List<String>> perms) {
        Image image = new Image(ImagesCore.INSTANCE.management());
        image.setAltText(ConstantsCore.INSTANCE.Management());
        final FormStylePopup editor = new FormStylePopup(image, ConstantsCore.INSTANCE.EditUser0(userName));
        editor.addRow((Widget)new HTML("<i>" + ConstantsCore.INSTANCE.UserAuthenticationTip() + "</i>"));
        VerticalPanel vp = new VerticalPanel();
        editor.addAttribute("", this.doPermsPanel(perms, (Panel)vp));
        HorizontalPanel hp = new HorizontalPanel();
        Button save = new Button(ConstantsCore.INSTANCE.SaveChanges());
        hp.add((Widget)save);
        editor.addAttribute("", (Widget)hp);
        save.addClickHandler(this.createClickHandlerForSaveButton(userName, perms, editor));
        Button cancel = new Button(ConstantsCore.INSTANCE.Cancel());
        hp.add((Widget)cancel);
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                editor.hide();
            }
        });
        editor.show();
    }

    private ClickHandler createClickHandlerForSaveButton(final String userName, final Map<String, List<String>> perms, final FormStylePopup editor) {
        return new ClickHandler(){

            public void onClick(ClickEvent w) {
                LoadingPopup.showMessage(ConstantsCore.INSTANCE.Updating());
                PermissionsPagedTablePresenter.this.repositoryService.updateUserPermissions(userName, perms, new GenericCallback<Void>(){

                    public void onSuccess(Void a) {
                        LoadingPopup.close();
                        PermissionsPagedTablePresenter.this.view.refresh();
                        editor.hide();
                    }
                });
            }
        };
    }

    private Widget doPermsPanel(final Map<String, List<String>> perms, final Panel vp) {
        vp.clear();
        for (Map.Entry<String, List<String>> perm : perms.entrySet()) {
            if (perm.getKey().equals("admin")) {
                HorizontalPanel h = new HorizontalPanel();
                h.add((Widget)new HTML("<b>" + ConstantsCore.INSTANCE.ThisUserIsAnAdministrator() + "</b>"));
                Button del = new Button(ConstantsCore.INSTANCE.RemoveAdminRights());
                del.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        if (Window.confirm((String)ConstantsCore.INSTANCE.AreYouSureYouWantToRemoveAdministratorPermissions())) {
                            perms.remove("admin");
                            PermissionsPagedTablePresenter.this.doPermsPanel(perms, vp);
                        }
                    }
                });
                h.add((Widget)del);
                vp.add((Widget)h);
                continue;
            }
            final String permType = perm.getKey();
            final List<String> permList = perm.getValue();
            Grid g = new Grid(permList.size() + 1, 3);
            g.setWidget(0, 0, (Widget)new HTML("<b>[" + permType + "] for:</b>"));
            for (int i = 0; i < permList.size(); ++i) {
                final String p = permList.get(i);
                ImageButton del = new ImageButton(GuvnorImages.INSTANCE.DeleteItemSmall(), ConstantsCore.INSTANCE.RemovePermission(), new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        if (Window.confirm((String)ConstantsCore.INSTANCE.AreYouSureYouWantToRemovePermission0(p))) {
                            permList.remove(p);
                            if (permList.size() == 0) {
                                perms.remove(permType);
                            }
                            PermissionsPagedTablePresenter.this.doPermsPanel(perms, vp);
                        }
                    }
                });
                g.setWidget(i + 1, 1, (Widget)new SmallLabel(p));
                g.setWidget(i + 1, 2, (Widget)del);
            }
            vp.add((Widget)g);
        }
        ImageButton newPermission = new ImageButton(GuvnorImages.INSTANCE.NewItem(), ConstantsCore.INSTANCE.AddANewPermission(), this.createClickHandlerForNewPersmissionImageButton(perms, vp));
        vp.add((Widget)newPermission);
        return vp;
    }

    private ClickHandler createClickHandlerForNewPersmissionImageButton(final Map<String, List<String>> perms, final Panel vp) {
        return new ClickHandler(){

            public void onClick(ClickEvent w) {
                FormStylePopup pop = new FormStylePopup();
                final ListBox permTypeBox = new ListBox();
                permTypeBox.addItem(ConstantsCore.INSTANCE.Loading());
                HorizontalPanel hp = new HorizontalPanel();
                hp.add((Widget)permTypeBox);
                hp.add((Widget)new InfoPopup(ConstantsCore.INSTANCE.PermissionDetails(), ConstantsCore.INSTANCE.PermissionDetailsTip()));
                pop.addAttribute(ConstantsCore.INSTANCE.PermissionType(), (Widget)hp);
                PermissionsPagedTablePresenter.this.repositoryService.listAvailablePermissionRoleTypes((AsyncCallback<List<String>>)new GenericCallback<List<String>>(){

                    public void onSuccess(List<String> items) {
                        permTypeBox.clear();
                        permTypeBox.addItem(ConstantsCore.INSTANCE.pleaseChoose1());
                        for (String roleType : items) {
                            permTypeBox.addItem(roleType);
                        }
                    }
                });
                permTypeBox.addChangeHandler(this.createChangeHandlerForPermTypeBox(perms, vp, pop, permTypeBox));
                pop.show();
            }

            private ChangeHandler createChangeHandlerForPermTypeBox(final Map<String, List<String>> perms2, final Panel vp2, final FormStylePopup pop, final ListBox permTypeBox) {
                return new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        pop.clear();
                        String sel = permTypeBox.getItemText(permTypeBox.getSelectedIndex());
                        if (sel.equals("admin")) {
                            this.createButtonsAndHandlersForAdmin(perms2, vp2, pop);
                        } else if (sel.startsWith("analyst")) {
                            CategoryExplorerWidget cat = this.createCategoryExplorerWidget(perms2, vp2, pop, sel);
                            pop.addAttribute(ConstantsCore.INSTANCE.SelectCategoryToProvidePermissionFor(), (Widget)cat);
                        } else if (sel.startsWith("package")) {
                            this.createButtonsPanelsAndHandlersForPackage(perms2, vp2, pop, sel);
                        }
                    }

                    private void createButtonsPanelsAndHandlersForPackage(final Map<String, List<String>> perms, final Panel vp, final FormStylePopup pop2, final String sel) {
                        final RulePackageSelector rps = new RulePackageSelector(true);
                        Button ok = new Button(ConstantsCore.INSTANCE.OK());
                        ok.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent w) {
                                String pkName = rps.getSelectedPackage();
                                if (perms.containsKey(sel)) {
                                    ((List)perms.get(sel)).add("package=" + pkName);
                                } else {
                                    ArrayList<String> ls = new ArrayList<String>();
                                    ls.add("package=" + pkName);
                                    perms.put(sel, ls);
                                }
                                PermissionsPagedTablePresenter.this.doPermsPanel(perms, vp);
                                pop2.hide();
                            }
                        });
                        HorizontalPanel hp = new HorizontalPanel();
                        hp.add((Widget)rps);
                        hp.add((Widget)ok);
                        pop2.addAttribute(ConstantsCore.INSTANCE.SelectPackageToApplyPermissionTo(), (Widget)hp);
                    }

                    private CategoryExplorerWidget createCategoryExplorerWidget(final Map<String, List<String>> perms, final Panel vp, final FormStylePopup pop2, final String sel) {
                        return new CategoryExplorerWidget(new CategorySelectHandler(){

                            @Override
                            public void selected(String selectedPath) {
                                if (perms.containsKey(sel)) {
                                    ((List)perms.get(sel)).add("category=" + selectedPath);
                                } else {
                                    ArrayList<String> ls = new ArrayList<String>();
                                    ls.add("category=" + selectedPath);
                                    perms.put(sel, ls);
                                }
                                PermissionsPagedTablePresenter.this.doPermsPanel(perms, vp);
                                pop2.hide();
                            }
                        });
                    }

                    private void createButtonsAndHandlersForAdmin(final Map<String, List<String>> perms, final Panel vp, final FormStylePopup pop2) {
                        Button ok = new Button(ConstantsCore.INSTANCE.OK());
                        pop2.addAttribute(ConstantsCore.INSTANCE.MakeThisUserAdmin(), (Widget)ok);
                        ok.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent w) {
                                perms.put("admin", new ArrayList());
                                PermissionsPagedTablePresenter.this.doPermsPanel(perms, vp);
                                pop2.hide();
                            }
                        });
                        Button cancel = new Button(ConstantsCore.INSTANCE.Cancel());
                        pop2.addAttribute("", (Widget)cancel);
                        cancel.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent w) {
                                pop2.hide();
                            }
                        });
                    }
                };
            }
        };
    }
}

