/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SingleSelectionModel;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.client.widgets.query.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.AbstractPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SelectionColumn;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class PermissionsPagedTableView
extends AbstractPagedTable<PermissionsPageRow> {
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    @UiField
    protected Button createNewUserButton;
    @UiField
    protected Button deleteSelectedUserButton;
    @UiField
    protected Button openSelectedUserButton;
    private static PermissionsPagedTableViewBinder uiBinder = (PermissionsPagedTableViewBinder)GWT.create(PermissionsPagedTableViewBinder.class);
    private Command newUserCommand;
    private Command deleteUserCommand;
    private OpenItemCommand openSelectedCommand;
    private static final int PAGE_SIZE = 10;
    protected SingleSelectionModel<PermissionsPageRow> selectionModel;

    public PermissionsPagedTableView() {
        super(10);
    }

    @Override
    public SingleSelectionModel<PermissionsPageRow> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<PermissionsPageRow> columnPicker, SortableHeaderGroup<PermissionsPageRow> sortableHeaderGroup) {
        Column<PermissionsPageRow, String> userNameColumn = new Column<PermissionsPageRow, String>((Cell)new TextCell()){

            public String getValue(PermissionsPageRow row) {
                return row.getUserName();
            }
        };
        columnPicker.addColumn(userNameColumn, new SortableHeader<PermissionsPageRow, String>(sortableHeaderGroup, constants.UserName1(), userNameColumn), true);
        Column<PermissionsPageRow, String> isAdminColumn = new Column<PermissionsPageRow, String>((Cell)new TextCell()){

            public String getValue(PermissionsPageRow row) {
                return row.isAdministrator() ? constants.Yes() : "";
            }
        };
        columnPicker.addColumn(isAdminColumn, new SortableHeader<PermissionsPageRow, String>(sortableHeaderGroup, constants.Administrator(), isAdminColumn), true);
        Column<PermissionsPageRow, String> hasPackagePermissionsColumn = new Column<PermissionsPageRow, String>((Cell)new TextCell()){

            public String getValue(PermissionsPageRow row) {
                return row.hasPackagePermissions() ? constants.Yes() : "";
            }
        };
        columnPicker.addColumn(hasPackagePermissionsColumn, new SortableHeader<PermissionsPageRow, String>(sortableHeaderGroup, constants.HasPackagePermissions(), hasPackagePermissionsColumn), true);
        Column<PermissionsPageRow, String> hasCategoryPermissionsColumn = new Column<PermissionsPageRow, String>((Cell)new TextCell()){

            public String getValue(PermissionsPageRow row) {
                return row.hasCategoryPermissions() ? constants.Yes() : "";
            }
        };
        columnPicker.addColumn(hasCategoryPermissionsColumn, new SortableHeader<PermissionsPageRow, String>(sortableHeaderGroup, constants.HasCategoryPermissions(), hasCategoryPermissionsColumn), true);
    }

    @Override
    protected void doCellTable() {
        ProvidesKey<PermissionsPageRow> providesKey = new ProvidesKey<PermissionsPageRow>(){

            public Object getKey(PermissionsPageRow row) {
                return row.getUserName();
            }
        };
        this.cellTable = new CellTable((ProvidesKey)providesKey);
        this.selectionModel = new SingleSelectionModel((ProvidesKey)providesKey);
        this.cellTable.setSelectionModel(this.selectionModel);
        SelectionColumn.createAndAddSelectionColumn(this.cellTable);
        ColumnPicker<PermissionsPageRow> columnPicker = new ColumnPicker<PermissionsPageRow>(this.cellTable);
        SortableHeaderGroup<PermissionsPageRow> sortableHeaderGroup = new SortableHeaderGroup<PermissionsPageRow>(this.cellTable);
        this.addAncillaryColumns(columnPicker, sortableHeaderGroup);
        Column<PermissionsPageRow, String> openColumn = new Column<PermissionsPageRow, String>((Cell)new ButtonCell()){

            public String getValue(PermissionsPageRow row) {
                return constants.Open();
            }
        };
        openColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<PermissionsPageRow, String>(){

            public void update(int index, PermissionsPageRow row, String value) {
                PermissionsPagedTableView.this.openSelectedCommand.open(row.getUserName());
            }
        });
        columnPicker.addColumn(openColumn, (Header<String>)new TextHeader(constants.Open()), true);
        this.cellTable.setWidth("100%");
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"createNewUserButton"})
    void createNewUser(ClickEvent e) {
        this.newUserCommand.execute();
    }

    @UiHandler(value={"deleteSelectedUserButton"})
    void deleteSelectedUser(ClickEvent e) {
        this.deleteUserCommand.execute();
    }

    @UiHandler(value={"openSelectedUserButton"})
    void openSelectedUser(ClickEvent e) {
        String userName = ((PermissionsPageRow)this.selectionModel.getSelectedObject()).getUserName();
        this.openSelectedCommand.open(userName);
    }

    @UiHandler(value={"refreshButton"})
    void refresh(ClickEvent e) {
        this.refresh();
    }

    public void setNewUserCommand(Command newUserCommand) {
        this.newUserCommand = newUserCommand;
    }

    public void setDeleteUserCommand(Command deleteUserCommand) {
        this.deleteUserCommand = deleteUserCommand;
    }

    public void setOpenSelectedCommand(OpenItemCommand openSelectedCommand) {
        this.openSelectedCommand = openSelectedCommand;
    }

    public void setOpenSelectedCommand(AsyncDataProvider<PermissionsPageRow> dataProvider) {
    }

    static interface Presenter {
    }

    static interface PermissionsPagedTableViewBinder
    extends UiBinder<Widget, PermissionsPagedTableView> {
    }
}

