/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.resources.ComparableImageResource;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.StatePageRequest;
import org.drools.guvnor.client.rpc.StatePageRow;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.ComparableImageResourceCell;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;
import org.drools.guvnor.client.widgets.tables.TitledTextCell;
import org.drools.guvnor.client.widgets.tables.TitledTextColumn;

public class StatePagedTable
extends AbstractAssetPagedTable<StatePageRow> {
    private static final int PAGE_SIZE = 10;
    private final ClientFactory clientFactory;

    public StatePagedTable(final String stateName, ClientFactory clientFactory) {
        super(10, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<StatePageRow>(){

            protected void onRangeChanged(HasData<StatePageRow> display) {
                StatePageRequest request = new StatePageRequest();
                request.setStateName(stateName);
                request.setStartRowIndex(StatePagedTable.this.pager.getPageStart());
                request.setPageSize(StatePagedTable.this.pageSize);
                StatePagedTable.this.repositoryService.loadRuleListForState(request, (AsyncCallback<PageResponse<StatePageRow>>)new GenericCallback<PageResponse<StatePageRow>>(){

                    public void onSuccess(PageResponse<StatePageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<StatePageRow> columnPicker, SortableHeaderGroup<StatePageRow> sortableHeaderGroup) {
        Column<StatePageRow, ComparableImageResource> formatColumn = new Column<StatePageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(StatePageRow row) {
                AssetEditorFactory factory = StatePagedTable.this.clientFactory.getAssetEditorFactory();
                return new ComparableImageResource(row.getFormat(), factory.getAssetEditorIcon(row.getFormat()));
            }
        };
        columnPicker.addColumn(formatColumn, new SortableHeader<StatePageRow, ComparableImageResource>(sortableHeaderGroup, constants.Format(), formatColumn), true);
        TitledTextColumn<StatePageRow> titleColumn = new TitledTextColumn<StatePageRow>(){

            public TitledTextCell.TitledText getValue(StatePageRow row) {
                return new TitledTextCell.TitledText(row.getName(), row.getAbbreviatedDescription());
            }
        };
        columnPicker.addColumn(titleColumn, new SortableHeader<StatePageRow, TitledTextCell.TitledText>(sortableHeaderGroup, constants.Name(), titleColumn), true);
        TextColumn<StatePageRow> packageNameColumn = new TextColumn<StatePageRow>(){

            public String getValue(StatePageRow row) {
                return row.getPackageName();
            }
        };
        columnPicker.addColumn((Column<StatePageRow, ?>)packageNameColumn, new SortableHeader(sortableHeaderGroup, constants.PackageName(), packageNameColumn), true);
        TextColumn<StatePageRow> statusNameColumn = new TextColumn<StatePageRow>(){

            public String getValue(StatePageRow row) {
                return row.getStateName();
            }
        };
        columnPicker.addColumn((Column<StatePageRow, ?>)statusNameColumn, new SortableHeader(sortableHeaderGroup, constants.Status(), statusNameColumn), true);
        Column<StatePageRow, Date> lastModifiedColumn = new Column<StatePageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(StatePageRow row) {
                return row.getLastModified();
            }
        };
        columnPicker.addColumn(lastModifiedColumn, new SortableHeader<StatePageRow, Date>(sortableHeaderGroup, constants.LastModified(), lastModifiedColumn), true);
    }
}

