/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.converters.ConversionService;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.util.AssetPopulator;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.annotations.LoggedIn;

@ApplicationScoped
@Named(value="org.drools.guvnor.client.rpc.AssetService")
public class RepositoryAssetService
implements AssetService {
    private static final long serialVersionUID = 90111L;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetService.class);
    @Inject
    @Preferred
    protected RulesRepository rulesRepository;
    @Inject
    protected RepositoryAssetOperations repositoryAssetOperations;
    @Inject
    protected ServiceSecurity serviceSecurity;
    @Inject
    protected Backchannel backchannel;
    @Inject
    protected Identity identity;
    @Inject
    private ConversionService conversionService;

    public RulesRepository getRulesRepository() {
        return this.rulesRepository;
    }

    @Override
    @WebRemote
    @LoggedIn
    public Asset loadRuleAsset(String uuid) throws SerializationException {
        long time = System.currentTimeMillis();
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        Asset asset = new AssetPopulator().populateFrom(item);
        asset.setMetaData(this.repositoryAssetOperations.populateMetaData(item));
        this.serviceSecurity.checkIsPackageReadOnlyOrAnalystReadOnly(asset);
        ModuleItem pkgItem = this.handlePackageItem(item, asset);
        log.debug("Package: " + pkgItem.getName() + ", asset: " + item.getName() + ". Load time taken for asset: " + (System.currentTimeMillis() - time));
        UserInbox.recordOpeningEvent(item);
        return asset;
    }

    private ModuleItem handlePackageItem(AssetItem item, Asset asset) throws SerializationException {
        ModuleItem packageItem = item.getModule();
        ContentHandler handler = ContentManager.getHandler(asset.getFormat());
        handler.retrieveAssetContent(asset, item);
        asset.setReadonly(asset.getMetaData().isHasSucceedingVersion() || asset.isArchived());
        if (packageItem.isSnapshot()) {
            asset.setReadonly(true);
        }
        return packageItem;
    }

    @Override
    @WebRemote
    @LoggedIn
    public Asset[] loadRuleAssets(String[] uuids) throws SerializationException {
        return this.loadRuleAssets(Arrays.asList(uuids));
    }

    @Override
    @WebRemote
    @LoggedIn
    public String checkinVersion(Asset asset) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        log.info("USER:" + this.getCurrentUserName() + " CHECKING IN asset: [" + asset.getName() + "] UUID: [" + asset.getUuid() + "] ");
        return this.repositoryAssetOperations.checkinVersion(asset);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void restoreVersion(String versionUUID, String assetUUID, String comment) {
        this.repositoryAssetOperations.restoreVersion(versionUUID, assetUUID, comment);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult loadItemHistory(String uuid) throws SerializationException {
        VersionableItem assetItem = this.rulesRepository.loadItemByUUID(uuid);
        return this.repositoryAssetOperations.loadItemHistory(assetItem);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult loadAssetHistory(String packageUUID, String assetName) throws SerializationException {
        ModuleItem pi = this.rulesRepository.loadModuleByUUID(packageUUID);
        AssetItem assetItem = pi.loadAsset(assetName);
        this.serviceSecurity.checkSecurityPackageReadOnlyWithPackageUuid(assetItem.getModule().getUUID());
        return this.repositoryAssetOperations.loadItemHistory((VersionableItem)assetItem);
    }

    @Override
    @WebRemote
    @LoggedIn
    @Deprecated
    public TableDataResult loadArchivedAssets(int skip, int numRows) throws SerializationException {
        return this.repositoryAssetOperations.loadArchivedAssets(skip, numRows);
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<AdminArchivedPageRow> loadArchivedAssets(PageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryAssetOperations.loadArchivedAssets(request);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult listAssetsWithPackageName(String packageName, String[] formats, int skip, int numRows, String tableConfig) throws SerializationException {
        ModuleItem pkg = this.rulesRepository.loadModule(packageName);
        return this.listAssets(pkg.getUUID(), formats, skip, numRows, tableConfig);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult listAssets(String packageUuid, String[] formats, int skip, int numRows, String tableConfig) throws SerializationException {
        log.debug("Loading asset list for [" + packageUuid + "]");
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        return this.repositoryAssetOperations.listAssets(packageUuid, formats, skip, numRows, tableConfig);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String copyAsset(String assetUUID, String newPackage, String newName) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(newPackage);
        log.info("USER:" + this.getCurrentUserName() + " COPYING asset: [" + assetUUID + "] to [" + newName + "] in PACKAGE [" + newPackage + "]");
        return this.rulesRepository.copyAsset(assetUUID, newPackage, newName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void changeAssetPackage(String uuid, String newPackage, String comment) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(newPackage);
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        this.attachmentRemoved(item);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING PACKAGE OF asset: [" + uuid + "] to [" + newPackage + "]");
        this.rulesRepository.moveRuleItemModule(newPackage, uuid, comment);
        this.attachmentAdded(item);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void promoteAssetToGlobalArea(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName("globalArea");
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(item.getModuleName());
        this.attachmentRemoved(item);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING MODULE OF asset: [" + uuid + "] to [ globalArea ]");
        this.rulesRepository.moveRuleItemModule("globalArea", uuid, "promote asset to globalArea");
        this.attachmentAdded(item);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String buildAssetSource(Asset asset) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.repositoryAssetOperations.buildAssetSource(asset);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String renameAsset(String uuid, String newName) {
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(item);
        return this.repositoryAssetOperations.renameAsset(uuid, newName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void archiveAsset(String uuid) {
        this.archiveOrUnarchiveAsset(uuid, true);
    }

    @Override
    @WebRemote
    @LoggedIn
    public BuilderResult validateAsset(Asset asset) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.repositoryAssetOperations.validateAsset(asset);
    }

    @Override
    public void unArchiveAsset(String uuid) {
        this.archiveOrUnarchiveAsset(uuid, false);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void archiveAssets(String[] uuids, boolean value) {
        for (String uuid : uuids) {
            this.archiveOrUnarchiveAsset(uuid, value);
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public void removeAsset(String uuid) {
        try {
            AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
            this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(item.getModule().getUUID());
            item.remove();
            this.rulesRepository.save();
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to remove asset.", e);
            throw e;
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public void removeAssets(String[] uuids) {
        for (String uuid : uuids) {
            this.removeAsset(uuid);
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<AssetPageRow> findAssetPage(AssetPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryAssetOperations.findAssetPage(request);
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<QueryPageRow> quickFindAsset(QueryPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryAssetOperations.quickFindAsset(request);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult quickFindAsset(String searchText, boolean searchArchived, int skip, int numRows) throws SerializationException {
        return this.repositoryAssetOperations.quickFindAsset(searchText, searchArchived, skip, numRows);
    }

    @Override
    @LoggedIn
    public void lockAsset(String uuid) {
        this.repositoryAssetOperations.lockAsset(uuid);
    }

    @Override
    @LoggedIn
    public void unLockAsset(String uuid) {
        this.repositoryAssetOperations.unLockAsset(uuid);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializationException {
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        return this.repositoryAssetOperations.queryFullText(text, seekArchived, skip, numRows);
    }

    Asset[] loadRuleAssets(Collection<String> uuids) throws SerializationException {
        if (uuids == null) {
            return null;
        }
        HashSet<Asset> assets = new HashSet<Asset>();
        for (String uuid : uuids) {
            assets.add(this.loadRuleAsset(uuid));
        }
        return assets.toArray(new Asset[assets.size()]);
    }

    private void archiveOrUnarchiveAsset(String uuid, boolean archive) {
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(item);
        if (item.getModule().isArchived()) {
            throw new RulesRepositoryException("The package [" + item.getModuleName() + "] that asset [" + item.getName() + "] belongs to is archived. You need to unarchive it first.");
        }
        log.info("USER:" + this.getCurrentUserName() + " ARCHIVING asset: [" + item.getName() + "] UUID: [" + item.getUUID() + "] ");
        try {
            ContentHandler handler = this.getContentHandler(item);
            if (handler instanceof ICanHasAttachment) {
                ((ICanHasAttachment)((Object)handler)).onAttachmentRemoved(item);
            }
        }
        catch (IOException e) {
            log.error("Unable to remove asset attachment", e);
        }
        item.archiveItem(archive);
        ModuleItem pkg = item.getModule();
        pkg.updateBinaryUpToDate(false);
        RuleBaseCache.getInstance().remove(pkg.getUUID());
        if (archive) {
            item.checkin("archived");
        } else {
            item.checkin("unarchived");
        }
        this.push("packageChange", pkg.getName());
    }

    @Override
    @LoggedIn
    public List<DiscussionRecord> addToDiscussionForAsset(String assetId, String comment) {
        return this.repositoryAssetOperations.addToDiscussionForAsset(assetId, comment);
    }

    @Override
    @LoggedIn
    public void clearAllDiscussionsForAsset(String assetId) {
        this.serviceSecurity.checkSecurityIsAdmin();
        this.repositoryAssetOperations.clearAllDiscussionsForAsset(assetId);
    }

    @Override
    @LoggedIn
    public List<DiscussionRecord> loadDiscussionForAsset(String assetId) {
        return new Discussion().fromString(this.rulesRepository.loadAssetByUUID(assetId).getStringProperty("discussion"));
    }

    @Override
    @WebRemote
    @LoggedIn
    public void changeState(String uuid, String newState) {
        AssetItem asset = this.rulesRepository.loadAssetByUUID(uuid);
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING ASSET STATUS. Asset name, uuid: " + "[" + asset.getName() + ", " + asset.getUUID() + "]" + " to [" + newState + "]");
        String oldState = asset.getStateDescription();
        asset.updateState(newState);
        this.push("statusChange", oldState);
        this.push("statusChange", newState);
        this.addToDiscussionForAsset(asset.getUUID(), oldState + " -> " + newState);
        this.rulesRepository.save();
    }

    @Override
    @WebRemote
    @LoggedIn
    public void changePackageState(String uuid, String newState) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(uuid);
        ModuleItem pkg = this.rulesRepository.loadModuleByUUID(uuid);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING Package STATUS. Asset name, uuid: " + "[" + pkg.getName() + ", " + pkg.getUUID() + "]" + " to [" + newState + "]");
        pkg.changeStatus(newState);
        this.rulesRepository.save();
    }

    @Override
    @LoggedIn
    public String getAssetLockerUserName(String uuid) {
        return this.repositoryAssetOperations.getAssetLockerUserName(uuid);
    }

    @Override
    @LoggedIn
    public long getAssetCount(AssetPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        return this.repositoryAssetOperations.getAssetCount(request);
    }

    private void push(String messageType, String message) {
        this.backchannel.publish(new PushResponse(messageType, message));
    }

    private ContentHandler getContentHandler(AssetItem repoAsset) {
        return ContentManager.getHandler(repoAsset.getFormat());
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }

    private void attachmentRemoved(AssetItem item) {
        ICanHasAttachment attachmentHandler = null;
        ContentHandler contentHandler = ContentManager.getHandler(item.getFormat());
        if (contentHandler instanceof ICanHasAttachment) {
            attachmentHandler = (ICanHasAttachment)((Object)contentHandler);
            try {
                attachmentHandler.onAttachmentRemoved(item);
            }
            catch (IOException ioe) {
                log.error("Unable to remove asset attachment", ioe);
            }
        }
    }

    private void attachmentAdded(AssetItem item) {
        ICanHasAttachment attachmentHandler = null;
        ContentHandler contentHandler = ContentManager.getHandler(item.getFormat());
        if (contentHandler instanceof ICanHasAttachment) {
            attachmentHandler = (ICanHasAttachment)((Object)contentHandler);
            try {
                attachmentHandler.onAttachmentAdded(item);
            }
            catch (IOException ioe) {
                log.error("Unable to remove asset attachment", ioe);
            }
        }
    }

    @Override
    @LoggedIn
    public ConversionResult convertAsset(String uuid, String targetFormat) throws SerializationException {
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(item);
        return this.conversionService.convert(item, targetFormat);
    }
}

