/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageDeploymentURIHelper {
    private String version;
    private String packageName;
    private String assetName = null;
    private FileType fileType = FileType.UNKNOWN;

    public PackageDeploymentURIHelper(String uri) throws UnsupportedEncodingException {
        new URIProcessor().parseUri(uri);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return "LATEST".equals(this.version);
    }

    public boolean isSource() {
        return this.fileType == FileType.SOURCE;
    }

    public boolean isDocumentation() {
        return this.fileType == FileType.DOCUMENTATION;
    }

    public boolean isPng() {
        return this.fileType == FileType.PNG;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public boolean isAsset() {
        return this.assetName != null;
    }

    class URIProcessor {
        private static final String PDF = ".pdf";
        private static final String BPMN = ".bpmn";
        private static final String BPMN2 = ".bpmn2";
        private static final String DRL = ".drl";
        private static final String PNG = ".png";
        private String url;

        URIProcessor() {
        }

        public void parseUri(String uri) throws UnsupportedEncodingException {
            this.url = URLDecoder.decode(uri, "UTF-8");
            String extension = this.getFileExtensionIfAny();
            this.setFileTypeIfAny(extension);
            this.stripFileExtensionIfAny(extension);
            this.setPackageOrAssetData();
        }

        private void setPackageOrAssetData() {
            Pattern pattern = Pattern.compile(".*/(package|asset)/(.*)");
            Matcher matcher = pattern.matcher(this.url);
            if (matcher.matches()) {
                String result = matcher.group(2);
                String[] tokens = result.split("/");
                PackageDeploymentURIHelper.this.version = tokens[1];
                PackageDeploymentURIHelper.this.packageName = tokens[0];
                if (tokens.length == 3) {
                    PackageDeploymentURIHelper.this.assetName = tokens[2];
                }
            }
        }

        private void setFileTypeIfAny(String extension) {
            if (extension.equals(DRL) || extension.equals(BPMN) || extension.equals(BPMN2)) {
                PackageDeploymentURIHelper.this.fileType = FileType.SOURCE;
            } else if (extension.equals(PDF)) {
                PackageDeploymentURIHelper.this.fileType = FileType.DOCUMENTATION;
            } else if (extension.equals(PNG)) {
                PackageDeploymentURIHelper.this.fileType = FileType.PNG;
            }
        }

        private void stripFileExtensionIfAny(String extension) {
            if (extension.length() > 0) {
                this.url = this.url.substring(0, this.url.length() - extension.length());
            }
        }

        private String getFileExtensionIfAny() {
            if (this.isFileType(DRL)) {
                return DRL;
            }
            if (this.isFileType(BPMN)) {
                return BPMN;
            }
            if (this.isFileType(BPMN2)) {
                return BPMN2;
            }
            if (this.isFileType(PDF)) {
                return PDF;
            }
            if (this.isFileType(PNG)) {
                return PNG;
            }
            return "";
        }

        private boolean isFileType(String extension) {
            return this.url.endsWith(extension);
        }
    }

    private static enum FileType {
        UNKNOWN,
        SOURCE,
        DOCUMENTATION,
        PNG;

    }
}

